/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.shared;

import ch.systemsx.cisd.common.exceptions.ConfigurationFailureException;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.properties.ExtendedProperties;
import ch.systemsx.cisd.common.properties.PropertyParametersUtil;
import ch.systemsx.cisd.common.properties.PropertyUtils;
import ch.systemsx.cisd.common.reflection.ClassUtils;
import ch.systemsx.cisd.openbis.dss.generic.shared.DefaultDataSourceFactory;
import ch.systemsx.cisd.openbis.dss.generic.shared.IDataSourceProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.utils.DssPropertyParametersUtil;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataSourceDefinition;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataSourceWithDefinition;
import ch.systemsx.cisd.openbis.generic.shared.util.IDataSourceFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.log4j.Logger;

public class DataSourceProvider
implements IDataSourceProvider {
    private static final String DATA_SOURCE_FACTORY_CLASS_KEY = "factory-class";
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, DataSourceProvider.class);
    private final Map<String, DataSourceWithDefinition> dataSources;
    private final List<DataSourceDefinition> dataSourceDefinitions = new ArrayList<DataSourceDefinition>();
    public static final String DATA_SOURCE_KEY = "data-source";

    private DataSourceProvider() {
        PropertyParametersUtil.SectionProperties[] props;
        ExtendedProperties properties = DssPropertyParametersUtil.loadServiceProperties();
        this.dataSources = new HashMap<String, DataSourceWithDefinition>();
        PropertyParametersUtil.SectionProperties[] sectionPropertiesArray = props = PropertyParametersUtil.extractSectionProperties(properties, "data-sources", false);
        int n = props.length;
        int n2 = 0;
        while (n2 < n) {
            PropertyParametersUtil.SectionProperties sectionProperties = sectionPropertiesArray[n2];
            Properties dataSourceProperties = sectionProperties.getProperties();
            String dataSourceName = sectionProperties.getKey();
            String dataSourceFactoryClass = sectionProperties.getProperties().getProperty(DATA_SOURCE_FACTORY_CLASS_KEY, DefaultDataSourceFactory.class.getName());
            try {
                IDataSourceFactory factory = ClassUtils.create(IDataSourceFactory.class, dataSourceFactoryClass, new Object[0]);
                DataSourceWithDefinition dataSource = factory.create(dataSourceProperties);
                DataSourceDefinition definition = dataSource.getDefinitionOrNull();
                if (definition != null) {
                    definition.setCode(dataSourceName);
                    this.dataSourceDefinitions.add(definition);
                }
                this.dataSources.put(dataSourceName, dataSource);
                if (operationLog.isInfoEnabled()) {
                    operationLog.info("Data source '" + dataSourceName + "' defined.");
                }
            }
            catch (Exception ex) {
                throw new ConfigurationFailureException("Error occured while creating data source '" + dataSourceName + "': " + ex.getMessage(), ex);
            }
            ++n2;
        }
        if (operationLog.isInfoEnabled()) {
            operationLog.info("Data source provider initialized with " + this.dataSources.size() + " data sources.");
        }
    }

    @Override
    public DataSource getDataSource(String name) throws IllegalArgumentException {
        DataSourceWithDefinition result = this.dataSources.get(name);
        if (result == null) {
            String message = "Data source '" + name + "' has not been configured.";
            throw new IllegalArgumentException(message);
        }
        return result.getDataSource();
    }

    @Override
    public DataSource getDataSource(Properties properties) {
        return this.getDataSource(DataSourceProvider.extractDataSourceName(properties));
    }

    @Override
    public List<DataSourceDefinition> getAllDataSourceDefinitions() {
        return this.dataSourceDefinitions;
    }

    public static final String extractDataSourceName(Properties properties) {
        return PropertyUtils.getMandatoryProperty(properties, DATA_SOURCE_KEY);
    }
}

