/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.maintenance;

import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.common.exceptions.ConfigurationFailureException;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.maintenance.IDataStoreLockingMaintenanceTask;
import ch.systemsx.cisd.common.maintenance.IMaintenanceTask;
import ch.systemsx.cisd.common.maintenance.MaintenanceTaskParameters;
import ch.systemsx.cisd.common.reflection.ClassUtils;
import java.io.Closeable;
import java.io.IOException;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.log4j.Logger;

public class MaintenancePlugin {
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, MaintenancePlugin.class);
    private static ReentrantLock dataStoreLock = new ReentrantLock();
    private final IMaintenanceTask task;
    private final MaintenanceTaskParameters parameters;
    private final boolean requiresDataStoreLock;
    private Timer workerTimer;
    private volatile boolean stopped;

    public MaintenancePlugin(MaintenanceTaskParameters parameters) {
        this.parameters = parameters;
        try {
            this.task = ClassUtils.create(IMaintenanceTask.class, parameters.getClassName(), new Object[0]);
        }
        catch (Exception ex) {
            throw new ConfigurationFailureException("Cannot find the plugin class '" + parameters.getClassName() + "'", CheckedExceptionTunnel.unwrapIfNecessary((Exception)ex));
        }
        this.task.setUp(parameters.getPluginName(), parameters.getProperties());
        this.requiresDataStoreLock = this.requiresDataStoreLock();
    }

    public MaintenancePlugin(IMaintenanceTask task, MaintenanceTaskParameters parameters) {
        this.parameters = parameters;
        this.task = task;
        this.requiresDataStoreLock = this.requiresDataStoreLock();
    }

    private boolean requiresDataStoreLock() {
        if (this.task instanceof IDataStoreLockingMaintenanceTask) {
            return ((IDataStoreLockingMaintenanceTask)this.task).requiresDataStoreLock();
        }
        return false;
    }

    public String getPluginName() {
        return this.parameters.getPluginName();
    }

    public synchronized void start() {
        String timerThreadName = String.valueOf(this.parameters.getPluginName()) + " - Maintenance Plugin";
        this.workerTimer = new Timer(timerThreadName);
        MaintenanceTimerTask timerTask = new MaintenanceTimerTask();
        Date startDate = this.parameters.getStartDate();
        if (this.parameters.isExecuteOnlyOnce()) {
            this.workerTimer.schedule((TimerTask)timerTask, startDate);
            if (operationLog.isInfoEnabled()) {
                operationLog.info((Object)("Plugin scheduled: " + this.parameters.getPluginName() + ", single execution at " + startDate));
            }
        } else {
            this.workerTimer.schedule((TimerTask)timerTask, startDate, this.parameters.getIntervalSeconds() * 1000L);
            if (operationLog.isInfoEnabled()) {
                operationLog.info((Object)("Plugin scheduled: " + this.parameters.getPluginName() + ", first execution at " + startDate + ", scheduling interval: " + this.parameters.getIntervalSeconds() + "s."));
            }
        }
    }

    public synchronized void shutdown() {
        if (this.workerTimer != null) {
            this.workerTimer.cancel();
            this.workerTimer = null;
        }
        this.stopped = true;
        if (this.task instanceof Closeable) {
            try {
                ((Closeable)((Object)this.task)).close();
            }
            catch (IOException ex) {
                throw CheckedExceptionTunnel.wrapIfNecessary((Exception)ex);
            }
        }
    }

    private class MaintenanceTimerTask
    extends TimerTask {
        private MaintenanceTimerTask() {
        }

        @Override
        public void run() {
            if (MaintenancePlugin.this.stopped) {
                return;
            }
            this.acquireLockIfNecessary();
            try {
                try {
                    MaintenancePlugin.this.task.execute();
                }
                catch (Throwable th) {
                    operationLog.error((Object)("Exception when running maintenance task '" + MaintenancePlugin.this.task.getClass().getCanonicalName() + "'."), th);
                    this.releaseLockIfNecessay();
                }
            }
            finally {
                this.releaseLockIfNecessay();
            }
        }

        private void acquireLockIfNecessary() {
            if (MaintenancePlugin.this.requiresDataStoreLock) {
                dataStoreLock.lock();
            }
        }

        private void releaseLockIfNecessay() {
            if (MaintenancePlugin.this.requiresDataStoreLock) {
                dataStoreLock.unlock();
            }
        }
    }
}

