/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver.cifex;

import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.io.PropertyIOUtils;
import ch.systemsx.cisd.openbis.generic.shared.basic.DataSetUploadInfo;
import java.io.File;
import java.util.Properties;

public class CifexExtractorHelper {
    private static final String COMMENT_KEY = "comment";
    public static final String REQUEST_PROPERTIES_FILE = "request.properties";
    private static final String UPLOADING_USER_EMAIL_KEY = "user-email";

    public static DataSetUploadInfo getDataSetUploadInfo(File incomingDataSetPath) {
        Properties properties = CifexExtractorHelper.loadProperties(incomingDataSetPath, REQUEST_PROPERTIES_FILE);
        String comment = properties.getProperty(COMMENT_KEY);
        DataSetUploadInfo info = DataSetUploadInfo.DataSetUploadInfoHelper.extractFromCifexComment(comment);
        return info;
    }

    public static String getUploadingUserEmail(File incomingDataSetPath) {
        Properties properties = CifexExtractorHelper.loadProperties(incomingDataSetPath, REQUEST_PROPERTIES_FILE);
        return properties.getProperty(UPLOADING_USER_EMAIL_KEY);
    }

    private static Properties loadProperties(File incomingDataSetPath, String fileName) {
        File propertiesFile = new File(incomingDataSetPath, fileName);
        if (propertiesFile.isFile()) {
            return PropertyIOUtils.loadProperties(propertiesFile.getPath());
        }
        throw new UserFailureException("Request properties file '" + propertiesFile + "' does not exist or is not a 'normal' file.");
    }
}

