/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver.path;

import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.maintenance.IMaintenanceTask;
import ch.systemsx.cisd.common.time.DateTimeUtils;
import ch.systemsx.cisd.common.utilities.ITimeProvider;
import ch.systemsx.cisd.common.utilities.SystemTimeProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.IEncapsulatedOpenBISService;
import ch.systemsx.cisd.openbis.dss.generic.shared.IHierarchicalContentProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.ServiceProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.utils.DataSetAndPathInfoDBConsistencyChecker;
import ch.systemsx.cisd.openbis.generic.shared.dto.SimpleDataSetInformationDTO;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import org.apache.log4j.Logger;

public class DataSetAndPathInfoDBConsistencyCheckTask
implements IMaintenanceTask {
    static final String CHECKING_TIME_INTERVAL_KEY = "checking-time-interval";
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, DataSetAndPathInfoDBConsistencyCheckTask.class);
    private static final Logger notificationLog = LogFactory.getLogger(LogCategory.NOTIFY, DataSetAndPathInfoDBConsistencyCheckTask.class);
    private IEncapsulatedOpenBISService service;
    private IHierarchicalContentProvider fileProvider;
    private IHierarchicalContentProvider pathInfoProvider;
    private long timeInterval;
    private ITimeProvider timeProvider;

    public DataSetAndPathInfoDBConsistencyCheckTask() {
    }

    DataSetAndPathInfoDBConsistencyCheckTask(IHierarchicalContentProvider fileProvider, IHierarchicalContentProvider pathInfoProvider, IEncapsulatedOpenBISService service, ITimeProvider timeProvider) {
        this.fileProvider = fileProvider;
        this.pathInfoProvider = pathInfoProvider;
        this.service = service;
        this.timeProvider = timeProvider;
    }

    @Override
    public void setUp(String pluginName, Properties properties) {
        this.timeInterval = DateTimeUtils.getDurationInMillis(properties, CHECKING_TIME_INTERVAL_KEY, 86400000L);
    }

    @Override
    public void execute() {
        Date youngerThanDate = new Date(this.getTimeProvider().getTimeInMilliseconds() - this.timeInterval);
        List<SimpleDataSetInformationDTO> dataSets = this.getService().listOldestPhysicalDataSets(youngerThanDate, Integer.MAX_VALUE);
        operationLog.info((Object)("Check " + dataSets.size() + " data sets registered since " + DATE_FORMAT.format(youngerThanDate)));
        DataSetAndPathInfoDBConsistencyChecker checker = new DataSetAndPathInfoDBConsistencyChecker(this.fileProvider, this.pathInfoProvider);
        checker.check(dataSets);
        if (!checker.noErrorAndInconsitencyFound()) {
            StringBuilder builder = new StringBuilder();
            builder.append("File system and path info DB consistency check report for all data sets since ");
            builder.append(DATE_FORMAT.format(youngerThanDate)).append("\n\n");
            builder.append(checker.createReport());
            notificationLog.error((Object)builder.toString());
        }
    }

    private IEncapsulatedOpenBISService getService() {
        if (this.service == null) {
            this.service = ServiceProvider.getOpenBISService();
        }
        return this.service;
    }

    private ITimeProvider getTimeProvider() {
        if (this.timeProvider == null) {
            this.timeProvider = SystemTimeProvider.SYSTEM_TIME_PROVIDER;
        }
        return this.timeProvider;
    }
}

