/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver.registrator;

import ch.systemsx.cisd.etlserver.ITypeExtractor;
import ch.systemsx.cisd.openbis.dss.generic.shared.dto.DataSetInformation;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataSetType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.FileFormatType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.LocatorType;
import ch.systemsx.cisd.openbis.generic.shared.dto.ExtractableData;
import ch.systemsx.cisd.openbis.generic.shared.dto.NewProperty;
import ch.systemsx.cisd.openbis.generic.shared.util.EntityHelper;
import java.io.File;
import java.util.List;

public class DataSetRegistrationDetails<T extends DataSetInformation>
implements ITypeExtractor {
    private FileFormatType fileFormatType = new FileFormatType("PROPRIETARY");
    private boolean measuredData = true;
    private String processorType;
    private T dataSetInformation;

    @Override
    public FileFormatType getFileFormatType(File incomingDataSetPath) {
        return this.fileFormatType;
    }

    @Override
    public boolean isMeasuredData(File incomingDataSetPath) {
        return this.measuredData;
    }

    @Override
    public String getProcessorType(File incomingDataSetPath) {
        return this.processorType;
    }

    @Override
    public DataSetType getDataSetType(File incomingDataSetPath) {
        return this.getDataSetType();
    }

    @Override
    public LocatorType getLocatorType(File incomingDataSetPath) {
        return this.getLocatorType();
    }

    public LocatorType getLocatorType() {
        return new LocatorType("RELATIVE_LOCATION");
    }

    public FileFormatType getFileFormatType() {
        return this.fileFormatType;
    }

    public void setFileFormatType(FileFormatType fileFormatType) {
        this.fileFormatType = fileFormatType;
    }

    public void setFileFormatType(String fileFormatTypeCode) {
        this.fileFormatType = new FileFormatType();
        this.fileFormatType.setCode(fileFormatTypeCode);
    }

    public boolean isMeasuredData() {
        return this.measuredData;
    }

    public void setMeasuredData(boolean measuredData) {
        this.measuredData = measuredData;
    }

    public String getProcessorType() {
        return this.processorType;
    }

    public void setProcessorType(String processorType) {
        this.processorType = processorType;
    }

    public DataSetType getDataSetType() {
        return ((DataSetInformation)this.dataSetInformation).getDataSetType();
    }

    public void setDataSetType(DataSetType dataSetType) {
        ((DataSetInformation)this.dataSetInformation).setDataSetType(dataSetType);
    }

    public void setDataSetType(String dataSetTypeCode) {
        this.setDataSetType(new DataSetType(dataSetTypeCode));
    }

    public T getDataSetInformation() {
        return this.dataSetInformation;
    }

    public void setDataSetInformation(T dataSetInformation) {
        this.dataSetInformation = dataSetInformation;
    }

    public void setPropertyValue(String propertyCode, String propertyValue) {
        ExtractableData datasetExtractableData = ((DataSetInformation)this.dataSetInformation).getExtractableData();
        if (propertyValue == null) {
            datasetExtractableData.removeDataSetProperty(propertyCode);
        } else {
            List<NewProperty> properties = datasetExtractableData.getDataSetProperties();
            NewProperty property = EntityHelper.tryFindProperty(properties, propertyCode);
            if (property != null) {
                property.setValue(propertyValue);
            } else {
                properties.add(new NewProperty(propertyCode, propertyValue));
            }
        }
    }

    public String getPropertyValue(String propertyCode) {
        NewProperty property = EntityHelper.tryFindProperty(((DataSetInformation)this.dataSetInformation).getExtractableData().getDataSetProperties(), propertyCode);
        return property != null ? property.getValue() : null;
    }
}

