/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.common.io.hierarchical_content;

import ch.systemsx.cisd.common.action.IDelegatedAction;
import ch.systemsx.cisd.common.filesystem.FileUtilities;
import ch.systemsx.cisd.common.shared.basic.string.StringUtils;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.AbstractHierarchicalContent;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.HDF5ContainerBasedHierarchicalContentNode;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.IHierarchicalContentFactory;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.api.IHierarchicalContentNode;
import java.io.File;

class DefaultFileBasedHierarchicalContent
extends AbstractHierarchicalContent {
    private final IHierarchicalContentFactory hierarchicalContentFactory;
    private final File root;
    private final IDelegatedAction onCloseAction;
    private IHierarchicalContentNode rootNode;

    DefaultFileBasedHierarchicalContent(IHierarchicalContentFactory hierarchicalContentFactory, File file, IDelegatedAction onCloseAction) {
        assert (hierarchicalContentFactory != null);
        if (!file.exists()) {
            throw new IllegalArgumentException(String.valueOf(file.getAbsolutePath()) + " doesn't exist");
        }
        if (!file.isDirectory()) {
            throw new IllegalArgumentException(String.valueOf(file.getAbsolutePath()) + " is not a directory");
        }
        this.hierarchicalContentFactory = hierarchicalContentFactory;
        this.onCloseAction = onCloseAction;
        this.root = file;
    }

    @Override
    public IHierarchicalContentNode getRootNode() {
        if (this.rootNode == null) {
            this.rootNode = this.createFileNode(this.root);
        }
        return this.rootNode;
    }

    @Override
    public IHierarchicalContentNode getNode(String relativePath) {
        IHierarchicalContentNode nodeOrNull = this.tryGetNode(relativePath);
        if (nodeOrNull == null) {
            throw new IllegalArgumentException("Resource '" + relativePath + "' does not exist.");
        }
        return nodeOrNull;
    }

    @Override
    public IHierarchicalContentNode tryGetNode(String relativePath) {
        Object node = StringUtils.isBlank(relativePath) ? this.getRootNode() : (relativePath.startsWith("../") || relativePath.contains("/../") ? null : this.tryAsNode(new File(this.root, relativePath)));
        return node;
    }

    private IHierarchicalContentNode tryAsNode(File file) {
        if (file.exists()) {
            return this.createFileNode(file);
        }
        File existingFile = file;
        while (existingFile != null && !existingFile.exists()) {
            existingFile = existingFile.getParentFile();
        }
        if (existingFile != null && FileUtilities.isHDF5ContainerFile(existingFile)) {
            HDF5ContainerBasedHierarchicalContentNode containerNode = new HDF5ContainerBasedHierarchicalContentNode(this, existingFile);
            String relativePath = FileUtilities.getRelativeFilePath(existingFile, file);
            return containerNode.tryGetChildNode(relativePath);
        }
        return null;
    }

    private IHierarchicalContentNode createFileNode(File file) {
        return this.hierarchicalContentFactory.asHierarchicalContentNode(this, file);
    }

    @Override
    public void close() {
        if (this.onCloseAction != null) {
            this.onCloseAction.execute();
        }
    }

    public String toString() {
        return "DefaultFileBasedHierarchicalContent [root=" + this.root + "]";
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.root == null ? 0 : this.root.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DefaultFileBasedHierarchicalContent)) {
            return false;
        }
        DefaultFileBasedHierarchicalContent other = (DefaultFileBasedHierarchicalContent)obj;
        return !(this.root == null ? other.root != null : !this.root.equals(other.root));
    }
}

