/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server.plugins.jython;

import ch.systemsx.cisd.common.mail.EMailAddress;
import ch.systemsx.cisd.common.mail.IMailClient;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.jython.EmailSender;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.jython.api.IEmailSender;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.jython.api.IMailService;
import de.schlichtherle.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.util.ByteArrayDataSource;

public class MailService
implements IMailService {
    static String DEFAULT_SUBJECT = "";
    static String DEFAULT_BODY_TEXT = "";
    private final IEmailSenderService senderService;
    private final String defaultSubject;
    private final String defaultBodyText;

    public MailService(IMailClient mailClient, String recipientAddressOrNull) {
        this(mailClient, recipientAddressOrNull, DEFAULT_SUBJECT, DEFAULT_BODY_TEXT);
    }

    public MailService(IMailClient mailClient, String recipientAddressOrNull, String defaultSubject, String defaultBodyText) {
        this.senderService = MailService.createEmailSenderService(mailClient, recipientAddressOrNull);
        this.defaultSubject = defaultSubject;
        this.defaultBodyText = defaultBodyText;
    }

    @Override
    public IEmailSender createEmailSender() {
        return new EmailSender(this.senderService, this.defaultSubject, this.defaultBodyText);
    }

    static IEmailSenderService createEmailSenderService(final IMailClient mailClient, String recipientAddressOrNull) {
        final EMailAddress recipient = new EMailAddress(recipientAddressOrNull);
        return new IEmailSenderService(){

            @Override
            public void trySendEmail(String subject, String bodyText) {
                mailClient.sendEmailMessage(subject, bodyText, null, null, recipient);
            }

            @Override
            public void trySendEmailWithTextAttachment(String subject, String bodyText, String attachmentFileName, String attachmentText) throws IOException {
                ByteArrayDataSource dataSource = new ByteArrayDataSource(attachmentText, "text/plain");
                mailClient.sendEmailMessageWithAttachment(subject, bodyText, attachmentFileName, new DataHandler((DataSource)dataSource), null, null, recipient);
            }

            @Override
            public void trySendEmailWithFileAttachment(String subject, String bodyText, String attachmentFileName, String attachmentFilePath) throws FileNotFoundException, IOException {
                ByteArrayDataSource dataSource = new ByteArrayDataSource((InputStream)new FileInputStream(attachmentFilePath), "text/plain");
                mailClient.sendEmailMessageWithAttachment(subject, bodyText, attachmentFileName, new DataHandler((DataSource)dataSource), null, null, recipient);
            }
        };
    }

    static interface IEmailSenderService {
        public void trySendEmail(String var1, String var2);

        public void trySendEmailWithTextAttachment(String var1, String var2, String var3, String var4) throws IOException;

        public void trySendEmailWithFileAttachment(String var1, String var2, String var3, String var4) throws FileNotFoundException, IOException;
    }
}

