/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard;

import ch.rinn.restrictions.Private;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.utilities.ITimeProvider;
import ch.systemsx.cisd.common.utilities.SystemTimeProvider;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard.Copier;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard.DataSetCopier;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard.IImmutableCopierFactory;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard.IPathCopierFactory;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard.ISshCommandExecutorFactory;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard.ImmutableCopierFactory;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard.RsyncCopierFactory;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard.SshCommandExecutorFactory;
import ch.systemsx.cisd.openbis.dss.generic.shared.DataSetProcessingContext;
import ch.systemsx.cisd.openbis.generic.shared.dto.DatasetDescription;
import java.io.File;
import java.util.Map;
import java.util.Properties;

public class DataSetCopierForUsers
extends DataSetCopier {
    private static final String USER_PARAMETER_STRING = "${user}";
    private static final long serialVersionUID = 1L;

    public DataSetCopierForUsers(Properties properties, File storeRoot) {
        this(properties, storeRoot, new RsyncCopierFactory(), new SshCommandExecutorFactory(), new ImmutableCopierFactory(), SystemTimeProvider.SYSTEM_TIME_PROVIDER);
    }

    @Private
    DataSetCopierForUsers(Properties properties, File storeRoot, IPathCopierFactory pathCopierFactory, ISshCommandExecutorFactory sshCommandExecutorFactory, IImmutableCopierFactory immutableCopierFactory, ITimeProvider timeProvider) {
        super(properties, storeRoot, new Copier(properties, pathCopierFactory, sshCommandExecutorFactory, immutableCopierFactory){
            private static final long serialVersionUID = 1L;

            @Override
            protected String transformHostFile(String originalHostFile, Map<String, String> parameterBindings) {
                return DataSetCopierForUsers.createDestinationFileName(originalHostFile, parameterBindings);
            }
        }, timeProvider);
    }

    private static String createDestinationFileName(String originalHostFile, Map<String, String> parameterBindings) {
        int indexOfParameter = originalHostFile.indexOf(USER_PARAMETER_STRING);
        String hostFile = originalHostFile;
        if (indexOfParameter >= 0) {
            String user = parameterBindings.get("user");
            if (user == null) {
                throw new UserFailureException("Missing parameter 'user'.");
            }
            hostFile = String.valueOf(originalHostFile.substring(0, indexOfParameter)) + user + originalHostFile.substring(indexOfParameter + USER_PARAMETER_STRING.length());
        }
        return hostFile;
    }

    @Override
    protected String getProcessingDescription(DatasetDescription dataset, DataSetProcessingContext context) {
        return "Copy to " + DataSetCopierForUsers.createDestinationFileName(this.properties.getProperty("destination"), context.getParameterBindings());
    }
}

