/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.shared.utils;

import ch.systemsx.cisd.base.unix.Unix;
import ch.systemsx.cisd.common.properties.ExtendedProperties;
import ch.systemsx.cisd.openbis.dss.generic.shared.utils.DssPluginType;
import ch.systemsx.cisd.openbis.dss.generic.shared.utils.DssPropertyParametersUtil;
import ch.systemsx.cisd.openbis.generic.shared.coreplugin.CorePluginScanner;
import ch.systemsx.cisd.openbis.generic.shared.coreplugin.CorePluginsInjector;
import ch.systemsx.cisd.openbis.generic.shared.coreplugin.CorePluginsUtils;
import java.io.File;
import java.io.IOException;
import java.util.Map;

public class AutoSymlink {
    public static void main(String[] args) {
        ExtendedProperties properties = DssPropertyParametersUtil.loadProperties("etc/service.properties");
        CorePluginsUtils.addCorePluginsProperties(properties, CorePluginScanner.ScannerType.DSS);
        ExtendedProperties serviceProperties = DssPropertyParametersUtil.extendProperties(properties);
        CorePluginsInjector injector = new CorePluginsInjector(CorePluginScanner.ScannerType.DSS, DssPluginType.values());
        Map<String, File> pluginFolders = injector.injectCorePlugins(serviceProperties);
        try {
            File libDir = new File("lib");
            File[] fileArray = libDir.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File link = fileArray[n2];
                if (link.getName().startsWith("autolink-")) {
                    link.delete();
                }
                ++n2;
            }
            for (String key : pluginFolders.keySet()) {
                File pluginLibFolder = new File(String.valueOf(pluginFolders.get(key).getCanonicalPath()) + "/lib");
                if (!pluginLibFolder.exists()) continue;
                File[] fileArray2 = pluginLibFolder.listFiles();
                int n3 = fileArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    File jar = fileArray2[n4];
                    if (jar.isFile() && jar.getName().endsWith(".jar")) {
                        String link = String.valueOf(libDir.getAbsolutePath()) + "/autolink-" + key + "-" + jar.getName();
                        Unix.createSymbolicLink((String)jar.getAbsolutePath(), (String)link);
                    }
                    ++n4;
                }
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }
}

