/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application;

import ch.systemsx.cisd.openbis.generic.client.web.client.ICommonClientServiceAsync;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.AbstractPluginViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.GenericViewModel;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IGenericImageBundle;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IPageController;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.VoidAsyncCallback;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.DisplaySettingsManager;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.locator.ViewLocatorResolverRegistry;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.plugin.IClientPluginFactoryProvider;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.CompositeMessageProvider;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.DictonaryBasedMessageProvider;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.log.IProfilingTable;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.log.ProfilingTable;
import ch.systemsx.cisd.openbis.generic.shared.basic.ViewMode;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DisplaySettings;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.WebClientConfiguration;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.displaysettings.IDisplaySettingsUpdate;
import java.util.List;

public final class CommonViewContext
implements IViewContext<ICommonClientServiceAsync> {
    private static final String TECHNOLOGY_NAME = "common";
    private final ICommonClientServiceAsync service;
    private final IGenericImageBundle imageBundle;
    private final GenericViewModel viewModel;
    private final IPageController pageController;
    private DisplaySettingsManager displaySettingsManager;
    private IClientPluginFactoryProvider clientPluginFactoryProvider;
    private final CompositeMessageProvider messageProvider;
    private final ViewLocatorResolverRegistry locatorHandlerRegistry;
    private final IProfilingTable profilingTable;
    private final boolean isDebuggingEnabled;

    CommonViewContext(ICommonClientServiceAsync service, IGenericImageBundle imageBundle, IPageController pageController, boolean isLoggingEnabled, boolean isDebuggingEnabled, String basicPageTitle) {
        this.service = service;
        this.imageBundle = imageBundle;
        this.pageController = pageController;
        this.isDebuggingEnabled = isDebuggingEnabled;
        this.profilingTable = ProfilingTable.create(isLoggingEnabled);
        this.messageProvider = new CompositeMessageProvider();
        this.messageProvider.add(new DictonaryBasedMessageProvider(TECHNOLOGY_NAME));
        this.viewModel = new GenericViewModel();
        this.locatorHandlerRegistry = new ViewLocatorResolverRegistry();
        ClientStaticState.init(basicPageTitle);
    }

    final void setClientPluginFactoryProvider(IClientPluginFactoryProvider clientPluginFactoryProvider) {
        this.clientPluginFactoryProvider = clientPluginFactoryProvider;
    }

    @Override
    public final ICommonClientServiceAsync getService() {
        return this.service;
    }

    @Override
    public String getTechnology() {
        return TECHNOLOGY_NAME;
    }

    @Override
    public String getPropertyOrNull(String key) {
        return AbstractPluginViewContext.getPropertyOrNull(this, key);
    }

    @Override
    public final GenericViewModel getModel() {
        return this.viewModel;
    }

    @Override
    public void initDisplaySettingsManager() {
        DisplaySettings loggedUserDisplaySettings = this.viewModel.getSessionContext().getDisplaySettings();
        this.displaySettingsManager = this.createDisplaySettingsManager(loggedUserDisplaySettings, this.viewModel.getApplicationInfo().getWebClientConfiguration());
    }

    @Override
    public DisplaySettingsManager getDisplaySettingsManager() {
        assert (this.displaySettingsManager != null) : "displaySettingsManager not initialized";
        return this.displaySettingsManager;
    }

    private DisplaySettingsManager createDisplaySettingsManager(final DisplaySettings displaySettings, WebClientConfiguration webClientConfigurationDTO) {
        DisplaySettingsManager.IDisplaySettingsUpdater settingsUpdater = new DisplaySettingsManager.IDisplaySettingsUpdater(){

            @Override
            public void execute() {
                CommonViewContext.this.service.saveDisplaySettings(displaySettings, new VoidAsyncCallback<Void>(CommonViewContext.this));
            }

            @Override
            public void execute(IDisplaySettingsUpdate update) {
                CommonViewContext.this.service.updateDisplaySettings(update, new VoidAsyncCallback<Void>(CommonViewContext.this));
            }
        };
        return new DisplaySettingsManager(displaySettings, settingsUpdater, this);
    }

    @Override
    public final IGenericImageBundle getImageBundle() {
        return this.imageBundle;
    }

    @Override
    public final IPageController getPageController() {
        return this.pageController;
    }

    @Override
    public final IClientPluginFactoryProvider getClientPluginFactoryProvider() {
        return this.clientPluginFactoryProvider;
    }

    @Override
    public final IViewContext<ICommonClientServiceAsync> getCommonViewContext() {
        return this;
    }

    @Override
    public boolean containsKey(String key) {
        return this.messageProvider.containsKey(key);
    }

    @Override
    public String getMessage(String key, Object ... parameters) {
        return this.messageProvider.getMessage(key, parameters);
    }

    @Override
    public String getName() {
        return this.messageProvider.getName();
    }

    @Override
    public ICommonClientServiceAsync getCommonService() {
        return this.getService();
    }

    @Override
    public void addMessageSource(String messageSource) {
        this.messageProvider.add(new DictonaryBasedMessageProvider(messageSource));
    }

    @Override
    public ViewLocatorResolverRegistry getLocatorResolverRegistry() {
        return this.locatorHandlerRegistry;
    }

    @Override
    public final void clearLog() {
        this.profilingTable.clearLog();
    }

    @Override
    public final List<String> getLoggedEvents() {
        return this.profilingTable.getLoggedEvents();
    }

    @Override
    public final int log(String description) {
        return this.profilingTable.log(description);
    }

    @Override
    public void log(int taskId, String description) {
        this.profilingTable.log(taskId, description);
    }

    @Override
    public final void logStop(int taskId) {
        this.profilingTable.logStop(taskId);
    }

    @Override
    public boolean isLoggingEnabled() {
        return this.profilingTable.isLoggingEnabled();
    }

    @Override
    public boolean isDebuggingEnabled() {
        return this.isDebuggingEnabled;
    }

    @Override
    public boolean isSimpleOrEmbeddedMode() {
        return ClientStaticState.isSimpleMode();
    }

    public static final class ClientStaticState {
        private static ViewMode viewMode;
        private static String pageTitleSuffix;

        public static void init(String aPageTitleSuffix) {
            pageTitleSuffix = aPageTitleSuffix;
        }

        @Deprecated
        public static boolean isSimpleMode() {
            return viewMode != ViewMode.NORMAL;
        }

        public static void setViewMode(ViewMode viewModeParam) {
            viewMode = viewModeParam;
        }

        public static String getPageTitleSuffix() {
            return pageTitleSuffix;
        }
    }
}

