/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.model.renderer;

import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.ExternalHyperlink;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.MultilineHTML;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.VocabularyTerm;

public class VocabularyPropertyColRenderer {
    public static final String renderTerm(VocabularyTerm term) {
        assert (term != null) : "term is not set";
        String description = term.getDescription();
        String url = term.getUrl();
        String result = term.getCodeOrLabel();
        if (url != null) {
            result = ExternalHyperlink.createAnchorString(result, url);
        }
        if (term.isOfficial() == null || term.isOfficial().booleanValue()) {
            result = MultilineHTML.wrapUpInDivWithTooltip(result, description);
        } else {
            result = String.valueOf(result) + " (" + term.getRegistrator() + ")";
            result = MultilineHTML.wrapUpInDivWithTooltip(result, description, "color: grey; font-style:italic");
        }
        return result;
    }

    public static final String renderAsTooltip(VocabularyTerm term) {
        String unofficialOrEmpty;
        String code = term.getCode();
        String label = term.getLabel();
        String description = term.getDescription();
        String result = "";
        String string = unofficialOrEmpty = term.isOfficial() != false ? "" : "(ad hoc term added by " + term.getRegistrator() + ")";
        if (label == null) {
            result = String.valueOf(result) + "<b>" + code + " " + unofficialOrEmpty + "</b>";
        } else {
            result = String.valueOf(result) + "<b>" + label + " " + unofficialOrEmpty + "</b>";
            result = String.valueOf(result) + "<br>code: " + code;
        }
        if (description != null) {
            result = String.valueOf(result) + "<br><hr>description: <i>" + description + "</i>";
        }
        return result.replace(".", ". ");
    }
}

