/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.columns.framework;

import ch.systemsx.cisd.openbis.generic.shared.basic.IEntityInformationHolder;
import ch.systemsx.cisd.openbis.generic.shared.basic.IEntityInformationHolderWithPermId;
import ch.systemsx.cisd.openbis.generic.shared.basic.URLMethodWithParameters;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.MaterialIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Project;

public class LinkExtractor {
    public static final String createSampleBrowserLink(String spaceOrNull, String sampleTypeOrNull) {
        URLMethodWithParameters url = new URLMethodWithParameters("");
        url.addParameter("action", "BROWSE");
        url.addParameter("entity", EntityKind.SAMPLE.name());
        if (spaceOrNull != null) {
            url.addParameter("space", spaceOrNull);
        }
        if (sampleTypeOrNull != null) {
            url.addParameter("type", sampleTypeOrNull);
        }
        return LinkExtractor.tryPrint(url);
    }

    public static final String createMaterialBrowserLink(String materialTypeOrNull) {
        URLMethodWithParameters url = new URLMethodWithParameters("");
        url.addParameter("action", "BROWSE");
        url.addParameter("entity", EntityKind.MATERIAL.name());
        if (materialTypeOrNull != null) {
            url.addParameter("type", materialTypeOrNull);
        }
        return LinkExtractor.tryPrint(url);
    }

    public static final String createExperimentBrowserLink(String spaceOrNull, String projectOrNull, String experimentTypeOrNull) {
        URLMethodWithParameters url = new URLMethodWithParameters("");
        url.addParameter("action", "BROWSE");
        url.addParameter("entity", EntityKind.EXPERIMENT.name());
        if (spaceOrNull != null) {
            url.addParameter("space", spaceOrNull);
        }
        if (projectOrNull != null) {
            url.addParameter("project", projectOrNull);
        }
        if (experimentTypeOrNull != null) {
            url.addParameter("type", experimentTypeOrNull);
        }
        return LinkExtractor.tryPrint(url);
    }

    public static final String createMetaprojectLink(String metaprojectName) {
        URLMethodWithParameters url = new URLMethodWithParameters("");
        url.addParameter("action", "VIEW");
        url.addParameter("entity", "METAPROJECT");
        url.addParameter("name", metaprojectName);
        return LinkExtractor.tryPrint(url);
    }

    public static final String createMetaprojectBrowserLink() {
        URLMethodWithParameters url = new URLMethodWithParameters("");
        url.addParameter("action", "BROWSE");
        url.addParameter("entity", "METAPROJECT");
        return LinkExtractor.tryPrint(url);
    }

    public static final String createSearchLink(EntityKind entityKind) {
        URLMethodWithParameters url = new URLMethodWithParameters("");
        url.addParameter("action", "SEARCH");
        url.addParameter("entity", entityKind.name());
        return LinkExtractor.tryPrint(url);
    }

    public static String tryExtract(IEntityInformationHolderWithPermId entityOrNull) {
        if (entityOrNull == null) {
            return null;
        }
        if (entityOrNull.getEntityKind() == EntityKind.MATERIAL) {
            return LinkExtractor.tryExtractMaterial(entityOrNull);
        }
        return LinkExtractor.createPermlink(entityOrNull.getEntityKind(), entityOrNull.getPermId());
    }

    public static String createPermlink(EntityKind entityKind, String permId) {
        assert (entityKind != EntityKind.MATERIAL);
        URLMethodWithParameters url = new URLMethodWithParameters("");
        url.addParameter("entity", entityKind.name());
        url.addParameterWithoutEncoding("permId", permId);
        return LinkExtractor.tryPrint(url);
    }

    public static final String tryExtract(Project p) {
        if (p == null) {
            return null;
        }
        URLMethodWithParameters url = new URLMethodWithParameters("");
        url.addParameter("entity", "PROJECT");
        url.addParameter("code", p.getCode());
        url.addParameter("space", p.getSpace().getCode());
        return LinkExtractor.tryPrint(url);
    }

    public static final String tryExtractMaterial(IEntityInformationHolder material) {
        if (material == null) {
            return null;
        }
        return LinkExtractor.tryPrint(LinkExtractor.tryCreateMaterialLink(material.getCode(), material.getEntityType().getCode()));
    }

    public static final String tryExtract(MaterialIdentifier identifier) {
        if (identifier == null) {
            return null;
        }
        return LinkExtractor.tryPrint(LinkExtractor.tryCreateMaterialLink(identifier.getCode(), identifier.getTypeCode()));
    }

    protected static final URLMethodWithParameters tryCreateMaterialLink(String materialCode, String materialTypeCode) {
        if (materialCode == null || materialTypeCode == null) {
            return null;
        }
        URLMethodWithParameters url = new URLMethodWithParameters("");
        url.addParameter("entity", EntityKind.MATERIAL.name());
        url.addParameter("code", materialCode);
        url.addParameter("type", materialTypeCode);
        return url;
    }

    protected static String tryPrint(URLMethodWithParameters urlOrNull) {
        return urlOrNull == null ? null : urlOrNull.toString().substring(1);
    }
}

