/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.entity_type;

import ch.systemsx.cisd.openbis.generic.client.web.client.ICommonClientServiceAsync;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.ComponentProvider;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.CompositeDatabaseModificationObserver;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.DatabaseModificationAwareComponent;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.IDatabaseModificationObserver;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.MainTabPanel;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.model.DataSetKindModel;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.BorderLayoutDataFactory;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.DataSetKindSelectionWidget;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.data.DataSetTypeGrid;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.entity_type.AbstractEntityTypeGrid;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.entity_type.AddEntityTypeDialog;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.experiment.ExperimentTypeGrid;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.field.CheckBoxField;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.field.CodeField;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.field.DescriptionField;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.field.ScriptChooserField;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.material.MaterialTypeGrid;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.property_type.PropertyTypeAssignmentGrid;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.sample.SampleTypeGrid;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.GWTUtils;
import ch.systemsx.cisd.openbis.generic.client.web.client.exception.UserFailureException;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataSetType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataSetTypePropertyType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ExperimentType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ExperimentTypePropertyType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.MaterialType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.MaterialTypePropertyType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewETNewPTAssigments;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewETPTAssignment;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewPTNewAssigment;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.SampleType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.SampleTypePropertyType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Script;
import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.data.ModelData;
import com.extjs.gxt.ui.client.event.ButtonEvent;
import com.extjs.gxt.ui.client.event.SelectionListener;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.ContentPanel;
import com.extjs.gxt.ui.client.widget.Layout;
import com.extjs.gxt.ui.client.widget.MessageBox;
import com.extjs.gxt.ui.client.widget.TabItem;
import com.extjs.gxt.ui.client.widget.button.Button;
import com.extjs.gxt.ui.client.widget.button.ButtonBar;
import com.extjs.gxt.ui.client.widget.form.Field;
import com.extjs.gxt.ui.client.widget.form.FormPanel;
import com.extjs.gxt.ui.client.widget.form.TextField;
import com.extjs.gxt.ui.client.widget.layout.BorderLayout;
import com.extjs.gxt.ui.client.widget.layout.LayoutData;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.List;

public class NewEntityTypeForm
extends ContentPanel {
    public static final String BROWSER_ID = "openbis_new-entity-type-form";
    private final IViewContext<ICommonClientServiceAsync> viewContext;
    private final EntityKind kind;
    private final EntityType entityToEdit;
    private NewETNewPTAssigments newTypeWithAssigments;
    private final ComponentProvider componentProvider;
    private AbstractEntityTypeGrid<? extends EntityType> typeGrid;
    private FormPanel dialogForm;

    private NewEntityTypeForm(EntityKind kind, EntityType entityToEdit, IViewContext<ICommonClientServiceAsync> viewContext, ComponentProvider componentProvider) {
        this.kind = kind;
        this.entityToEdit = entityToEdit;
        this.viewContext = viewContext;
        this.componentProvider = componentProvider;
        this.setLayout((Layout)new BorderLayout());
        this.setHeaderVisible(false);
        this.setBorders(false);
        this.setBodyBorder(false);
        this.initForm();
    }

    public static DatabaseModificationAwareComponent create(EntityKind kind, EntityType entityToEdit, IViewContext<ICommonClientServiceAsync> viewContext, ComponentProvider componentProvider) {
        NewEntityTypeForm form = new NewEntityTypeForm(kind, entityToEdit, viewContext, componentProvider);
        return new DatabaseModificationAwareComponent((Component)form, (IDatabaseModificationObserver)new CompositeDatabaseModificationObserver());
    }

    private void initForm() {
        this.removeAll();
        this.newTypeWithAssigments = new NewETNewPTAssigments();
        this.newTypeWithAssigments.setAssigments(new ArrayList<NewPTNewAssigment>());
        this.initEntityTypeForm();
        if (this.entityToEdit == null) {
            this.initCreateEntity();
        } else {
            this.initEditEntity();
        }
        this.dialogForm.setHeaderVisible(true);
        this.dialogForm.setHeading("Entity Type Information:");
        this.dialogForm.setBorders(false);
        this.dialogForm.setBodyBorder(false);
        this.dialogForm.setLabelWidth(180);
        this.add((Widget)this.dialogForm, (LayoutData)BorderLayoutDataFactory.create(Style.LayoutRegion.NORTH, 370.0f));
        PropertyTypeAssignmentGrid grid = (PropertyTypeAssignmentGrid)PropertyTypeAssignmentGrid.create(this.viewContext, null, this.newTypeWithAssigments, this.entityToEdit != null).getComponent();
        grid.setLayoutOnChange(true);
        ContentPanel gridPanel = new ContentPanel();
        gridPanel.setLayout((Layout)new BorderLayout());
        gridPanel.setLayoutOnChange(true);
        gridPanel.setHeaderVisible(true);
        gridPanel.setHeading("Assigned Property Types:");
        gridPanel.setBorders(false);
        gridPanel.setBodyBorder(false);
        gridPanel.add((Widget)grid, (LayoutData)BorderLayoutDataFactory.create(Style.LayoutRegion.CENTER, 170.0f));
        this.add((Widget)gridPanel, (LayoutData)BorderLayoutDataFactory.create(Style.LayoutRegion.CENTER, 170.0f));
        ContentPanel bottomPanel = new ContentPanel();
        bottomPanel.setLayout((Layout)new BorderLayout());
        bottomPanel.setLayoutOnChange(false);
        bottomPanel.setHeaderVisible(false);
        bottomPanel.setBorders(false);
        bottomPanel.setBodyBorder(false);
        ButtonBar buttonBar = new ButtonBar();
        buttonBar.setMinButtonWidth(100);
        buttonBar.setAlignment(Style.HorizontalAlignment.RIGHT);
        Button button = this.getSaveButton();
        button.setStyleAttribute("padding-right", "10px");
        buttonBar.add((Component)button);
        bottomPanel.add((Widget)buttonBar, (LayoutData)BorderLayoutDataFactory.create(Style.LayoutRegion.EAST, 120.0f));
        this.add((Widget)bottomPanel, (LayoutData)BorderLayoutDataFactory.create(Style.LayoutRegion.SOUTH, 30.0f));
        this.layout();
    }

    private void initEntityTypeForm() {
        AddEntityTypeDialog<EntityType> dialog = null;
        switch (this.kind) {
            case SAMPLE: {
                this.typeGrid = (SampleTypeGrid)SampleTypeGrid.create(this.viewContext, this.componentProvider).getComponent();
                dialog = ((SampleTypeGrid)this.typeGrid).getNewDialog(new SampleType());
                break;
            }
            case DATA_SET: {
                this.typeGrid = (DataSetTypeGrid)DataSetTypeGrid.create(this.viewContext, this.componentProvider).getComponent();
                dialog = ((DataSetTypeGrid)this.typeGrid).getNewDialog(new DataSetType());
                break;
            }
            case EXPERIMENT: {
                this.typeGrid = (ExperimentTypeGrid)ExperimentTypeGrid.create(this.viewContext, this.componentProvider).getComponent();
                dialog = ((ExperimentTypeGrid)this.typeGrid).getNewDialog(new ExperimentType());
                break;
            }
            case MATERIAL: {
                this.typeGrid = (MaterialTypeGrid)MaterialTypeGrid.create(this.viewContext, this.componentProvider).getComponent();
                dialog = ((MaterialTypeGrid)this.typeGrid).getNewDialog(new MaterialType());
            }
        }
        List dialogFormIntoList = dialog.getItems();
        this.dialogForm = (FormPanel)dialogFormIntoList.get(0);
    }

    private void initCreateEntity() {
        switch (this.kind) {
            case SAMPLE: {
                SampleType sampleType = new SampleType();
                sampleType.setSampleTypePropertyTypes(new ArrayList<SampleTypePropertyType>());
                this.newTypeWithAssigments.setEntity(sampleType);
                break;
            }
            case DATA_SET: {
                DataSetType dataSetType = new DataSetType();
                dataSetType.setDataSetTypePropertyTypes(new ArrayList<DataSetTypePropertyType>());
                this.newTypeWithAssigments.setEntity(dataSetType);
                break;
            }
            case EXPERIMENT: {
                ExperimentType experimentType = new ExperimentType();
                experimentType.setExperimentTypePropertyTypes(new ArrayList<ExperimentTypePropertyType>());
                this.newTypeWithAssigments.setEntity(experimentType);
                break;
            }
            case MATERIAL: {
                MaterialType materialType = new MaterialType();
                materialType.setMaterialTypePropertyTypes(new ArrayList<MaterialTypePropertyType>());
                this.newTypeWithAssigments.setEntity(materialType);
            }
        }
        this.newTypeWithAssigments.getEntity().setCode("" + System.currentTimeMillis());
    }

    private void initEditEntity() {
        List formFields = this.dialogForm.getFields();
        switch (this.kind) {
            case SAMPLE: {
                SampleType sampleToEdit = (SampleType)this.entityToEdit;
                ((CodeField)((Object)formFields.get(0))).setValue(sampleToEdit.getCode());
                ((CodeField)((Object)formFields.get(0))).setEnabled(false);
                ((DescriptionField)((Object)formFields.get(1))).setValue(sampleToEdit.getDescription());
                if (sampleToEdit.getValidationScript() != null) {
                    ((ScriptChooserField)formFields.get(2)).setValue(sampleToEdit.getValidationScript().getName());
                }
                ((CheckBoxField)((Object)formFields.get(3))).setValue(sampleToEdit.isListable());
                ((CheckBoxField)((Object)formFields.get(4))).setValue(sampleToEdit.isShowContainer());
                ((CheckBoxField)((Object)formFields.get(5))).setValue(sampleToEdit.isShowParents());
                ((CheckBoxField)((Object)formFields.get(6))).setValue(sampleToEdit.isSubcodeUnique());
                ((CheckBoxField)((Object)formFields.get(7))).setValue(sampleToEdit.isAutoGeneratedCode());
                ((CheckBoxField)((Object)formFields.get(8))).setValue(sampleToEdit.isShowParentMetadata());
                ((TextField)formFields.get(9)).setValue((Object)sampleToEdit.getGeneratedCodePrefix());
                break;
            }
            case DATA_SET: {
                DataSetType datasetToEdit = (DataSetType)this.entityToEdit;
                ((CodeField)((Object)formFields.get(0))).setValue(datasetToEdit.getCode());
                ((CodeField)((Object)formFields.get(0))).setEnabled(false);
                ((DescriptionField)((Object)formFields.get(1))).setValue(datasetToEdit.getDescription());
                if (datasetToEdit.getValidationScript() != null) {
                    ((ScriptChooserField)formFields.get(2)).setValue(datasetToEdit.getValidationScript().getName());
                }
                ((DataSetKindSelectionWidget)formFields.get(3)).setValue((ModelData)new DataSetKindModel(datasetToEdit.getDataSetKind()));
                ((DataSetKindSelectionWidget)formFields.get(3)).setEnabled(false);
                ((CheckBoxField)((Object)formFields.get(4))).setValue(datasetToEdit.isDeletionDisallow());
                ((TextField)formFields.get(5)).setValue((Object)datasetToEdit.getMainDataSetPattern());
                ((TextField)formFields.get(6)).setValue((Object)datasetToEdit.getMainDataSetPath());
                break;
            }
            case EXPERIMENT: {
                ExperimentType experimentToEdit = (ExperimentType)this.entityToEdit;
                ((CodeField)((Object)formFields.get(0))).setValue(experimentToEdit.getCode());
                ((CodeField)((Object)formFields.get(0))).setEnabled(false);
                ((DescriptionField)((Object)formFields.get(1))).setValue(experimentToEdit.getDescription());
                if (experimentToEdit.getValidationScript() == null) break;
                ((ScriptChooserField)formFields.get(2)).setValue(experimentToEdit.getValidationScript().getName());
                break;
            }
            case MATERIAL: {
                MaterialType materialToEdit = (MaterialType)this.entityToEdit;
                ((CodeField)((Object)formFields.get(0))).setValue(materialToEdit.getCode());
                ((CodeField)((Object)formFields.get(0))).setEnabled(false);
                ((DescriptionField)((Object)formFields.get(1))).setValue(materialToEdit.getDescription());
                if (materialToEdit.getValidationScript() == null) break;
                ((ScriptChooserField)formFields.get(2)).setValue(materialToEdit.getValidationScript().getName());
            }
        }
        this.newTypeWithAssigments.setEntity(this.entityToEdit);
        int i = 0;
        while (i < this.entityToEdit.getAssignedPropertyTypes().size()) {
            NewPTNewAssigment assigment = new NewPTNewAssigment();
            assigment.setExistingPropertyType(true);
            assigment.setPropertyType(this.entityToEdit.getAssignedPropertyTypes().get(i).getPropertyType());
            NewETPTAssignment newETPTAssigment = new NewETPTAssignment();
            newETPTAssigment.setPropertyTypeCode(this.entityToEdit.getAssignedPropertyTypes().get(i).getPropertyType().getCode());
            newETPTAssigment.setEntityKind(this.entityToEdit.getEntityKind());
            newETPTAssigment.setOrdinal(this.entityToEdit.getAssignedPropertyTypes().get(i).getOrdinal());
            newETPTAssigment.setSection(this.entityToEdit.getAssignedPropertyTypes().get(i).getSection());
            newETPTAssigment.setMandatory(this.entityToEdit.getAssignedPropertyTypes().get(i).isMandatory());
            newETPTAssigment.setDynamic(this.entityToEdit.getAssignedPropertyTypes().get(i).isDynamic());
            newETPTAssigment.setManaged(this.entityToEdit.getAssignedPropertyTypes().get(i).isManaged());
            newETPTAssigment.setShownInEditView(this.entityToEdit.getAssignedPropertyTypes().get(i).isShownInEditView());
            newETPTAssigment.setShowRawValue(this.entityToEdit.getAssignedPropertyTypes().get(i).getShowRawValue());
            newETPTAssigment.setModificationDate(this.entityToEdit.getAssignedPropertyTypes().get(i).getModificationDate());
            assigment.setAssignment(newETPTAssigment);
            if (this.entityToEdit.getAssignedPropertyTypes().get(i).getScript() != null) {
                assigment.getAssignment().setScriptName(this.entityToEdit.getAssignedPropertyTypes().get(i).getScript().getName());
            }
            this.newTypeWithAssigments.getAssigments().add(assigment);
            ++i;
        }
    }

    private Button getSaveButton() {
        Button save = new Button("Save", (SelectionListener)new SelectionListener<ButtonEvent>(){

            public final void componentSelected(ButtonEvent ce) {
                if (NewEntityTypeForm.this.dialogForm.isValid()) {
                    NewEntityTypeForm.this.setEntityFromForm();
                    for (NewPTNewAssigment assigment : NewEntityTypeForm.this.newTypeWithAssigments.getAssigments()) {
                        assigment.getAssignment().setEntityTypeCode(NewEntityTypeForm.this.newTypeWithAssigments.getEntity().getCode());
                    }
                    if (NewEntityTypeForm.this.entityToEdit == null) {
                        ((ICommonClientServiceAsync)NewEntityTypeForm.this.viewContext.getService()).registerEntitytypeAndAssignPropertyTypes(NewEntityTypeForm.this.newTypeWithAssigments, new AsyncCallbackEntityType());
                    } else {
                        ((ICommonClientServiceAsync)NewEntityTypeForm.this.viewContext.getService()).updateEntitytypeAndPropertyTypes(NewEntityTypeForm.this.newTypeWithAssigments, new AsyncCallbackEntityType());
                    }
                }
            }
        });
        return save;
    }

    private void setEntityFromForm() {
        List formFields = this.dialogForm.getFields();
        switch (this.kind) {
            case SAMPLE: {
                SampleType toSaveSample = (SampleType)this.newTypeWithAssigments.getEntity();
                toSaveSample.setCode((String)((Field)formFields.get(0)).getValue());
                toSaveSample.setDescription((String)((Field)formFields.get(1)).getValue());
                ScriptChooserField cfr_ignored_0 = (ScriptChooserField)formFields.get(2);
                if (((Field)formFields.get(2)).getValue() != null) {
                    Script script = new Script();
                    script.setName((String)((Field)formFields.get(2)).getValue());
                    toSaveSample.setValidationScript(script);
                }
                toSaveSample.setListable((Boolean)((Field)formFields.get(3)).getValue());
                toSaveSample.setShowContainer((Boolean)((Field)formFields.get(4)).getValue());
                toSaveSample.setShowParents((Boolean)((Field)formFields.get(5)).getValue());
                toSaveSample.setSubcodeUnique((Boolean)((Field)formFields.get(6)).getValue());
                toSaveSample.setAutoGeneratedCode((Boolean)((Field)formFields.get(7)).getValue());
                toSaveSample.setShowParentMetadata((Boolean)((Field)formFields.get(8)).getValue());
                toSaveSample.setGeneratedCodePrefix((String)((Field)formFields.get(9)).getValue());
                this.newTypeWithAssigments.setEntity(toSaveSample);
                break;
            }
            case DATA_SET: {
                DataSetType toSaveDataSet = (DataSetType)this.newTypeWithAssigments.getEntity();
                toSaveDataSet.setCode((String)((Field)formFields.get(0)).getValue());
                toSaveDataSet.setDescription((String)((Field)formFields.get(1)).getValue());
                if (((Field)formFields.get(2)).getValue() != null) {
                    Script script = new Script();
                    script.setName((String)((Field)formFields.get(2)).getValue());
                    toSaveDataSet.setValidationScript(script);
                }
                toSaveDataSet.setDataSetKind(((DataSetKindModel)((Object)((DataSetKindSelectionWidget)formFields.get(3)).getValue())).getBaseObject());
                toSaveDataSet.setDeletionDisallow((Boolean)((Field)formFields.get(4)).getValue());
                toSaveDataSet.setMainDataSetPattern((String)((Field)formFields.get(5)).getValue());
                toSaveDataSet.setMainDataSetPath((String)((Field)formFields.get(6)).getValue());
                this.newTypeWithAssigments.setEntity(toSaveDataSet);
                break;
            }
            case EXPERIMENT: {
                ExperimentType toSaveExperiment = (ExperimentType)this.newTypeWithAssigments.getEntity();
                toSaveExperiment.setCode((String)((Field)formFields.get(0)).getValue());
                toSaveExperiment.setDescription((String)((Field)formFields.get(1)).getValue());
                if (((Field)formFields.get(2)).getValue() != null) {
                    Script script = new Script();
                    script.setName((String)((Field)formFields.get(2)).getValue());
                    toSaveExperiment.setValidationScript(script);
                }
                this.newTypeWithAssigments.setEntity(toSaveExperiment);
                break;
            }
            case MATERIAL: {
                MaterialType toSaveMaterial = (MaterialType)this.newTypeWithAssigments.getEntity();
                toSaveMaterial.setCode((String)((Field)formFields.get(0)).getValue());
                toSaveMaterial.setDescription((String)((Field)formFields.get(1)).getValue());
                if (((Field)formFields.get(2)).getValue() != null) {
                    Script script = new Script();
                    script.setName((String)((Field)formFields.get(2)).getValue());
                    toSaveMaterial.setValidationScript(script);
                }
                this.newTypeWithAssigments.setEntity(toSaveMaterial);
            }
        }
    }

    public static String getTabId(EntityKind kind, EntityType type) {
        if (type == null) {
            return "openbis_new-entity-type-form-" + kind.name() + "-New";
        }
        return "openbis_new-entity-type-form-" + kind.name() + "-" + type.getCode();
    }

    private class AsyncCallbackEntityType
    implements AsyncCallback<String> {
        private AsyncCallbackEntityType() {
        }

        public void onFailure(Throwable throwable) {
            UserFailureException userException;
            String details;
            String message = "Error";
            if (throwable instanceof UserFailureException && (details = GWTUtils.translateToHtmlLineBreaks((userException = (UserFailureException)throwable).getMessage())) != null) {
                message = details;
            }
            MessageBox.alert((String)"Error", (String)message, null);
        }

        public void onSuccess(String result) {
            if (NewEntityTypeForm.this.entityToEdit == null) {
                MessageBox.info((String)"Success", (String)"Registration Successful.", null);
            } else {
                MessageBox.info((String)"Success", (String)"Update Successful.", null);
            }
            MainTabPanel tabPanel = (MainTabPanel)NewEntityTypeForm.this.componentProvider.tryGetMainTabPanel();
            String getTabId = String.valueOf(NewEntityTypeForm.getTabId(NewEntityTypeForm.this.kind, NewEntityTypeForm.this.entityToEdit)) + "_tab";
            TabItem item = (TabItem)tabPanel.getItemByItemId(getTabId);
            item.close();
        }
    }
}

