/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid;

import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.ColumnDataModel;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.GridCustomColumnInfo;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.GridCustomColumn;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public abstract class AbstractColumnSettingsDataModelProvider {
    private final List<ColumnDataModel> columnDataModels;
    private List<GridCustomColumn> lastLoadedCustomColumnsOrNull;

    protected abstract void onClose(List<ColumnDataModel> var1);

    public AbstractColumnSettingsDataModelProvider(List<ColumnDataModel> columnDataModels) {
        this.columnDataModels = columnDataModels;
        this.lastLoadedCustomColumnsOrNull = null;
    }

    public List<ColumnDataModel> getColumnDataModels() {
        return this.columnDataModels;
    }

    public void refreshCustomColumns(List<GridCustomColumn> customColumns) {
        if (this.lastLoadedCustomColumnsOrNull != null) {
            List<GridCustomColumn> addedColumns = AbstractColumnSettingsDataModelProvider.getFreshColumns(this.lastLoadedCustomColumnsOrNull, customColumns);
            this.addColumns(addedColumns);
            List<GridCustomColumn> deletedColumns = AbstractColumnSettingsDataModelProvider.getFreshColumns(customColumns, this.lastLoadedCustomColumnsOrNull);
            this.deleteColumns(deletedColumns);
        }
        this.lastLoadedCustomColumnsOrNull = customColumns;
    }

    public List<GridCustomColumnInfo> tryGetCustomColumnsInfo() {
        if (this.lastLoadedCustomColumnsOrNull == null) {
            return null;
        }
        ArrayList<GridCustomColumnInfo> result = new ArrayList<GridCustomColumnInfo>();
        for (GridCustomColumn column : this.lastLoadedCustomColumnsOrNull) {
            result.add(this.createCustomColumnInfo(column));
        }
        return result;
    }

    private GridCustomColumnInfo createCustomColumnInfo(GridCustomColumn column) {
        return new GridCustomColumnInfo(AbstractColumnSettingsDataModelProvider.getId(column), column.getName(), column.getDescription(), column.getDataType());
    }

    private void addColumns(List<GridCustomColumn> columns) {
        for (GridCustomColumn column : columns) {
            ColumnDataModel columnDataModel = AbstractColumnSettingsDataModelProvider.createColumnDataModel(column);
            this.columnDataModels.add(columnDataModel);
        }
    }

    private void deleteColumns(List<GridCustomColumn> columns) {
        for (GridCustomColumn column : columns) {
            int ix = this.tryFindColumnIx(AbstractColumnSettingsDataModelProvider.getId(column));
            if (ix != -1) {
                this.columnDataModels.remove(ix);
                continue;
            }
            throw new IllegalStateException("cannot remove a column " + AbstractColumnSettingsDataModelProvider.getId(column));
        }
    }

    private static List<GridCustomColumn> getFreshColumns(List<GridCustomColumn> previous, List<GridCustomColumn> current) {
        ArrayList<GridCustomColumn> result = new ArrayList<GridCustomColumn>();
        Set<String> previousIds = AbstractColumnSettingsDataModelProvider.extractColumnIds(previous);
        for (GridCustomColumn column : current) {
            if (previousIds.contains(AbstractColumnSettingsDataModelProvider.getId(column))) continue;
            result.add(column);
        }
        return result;
    }

    private static String getId(GridCustomColumn column) {
        return column.getCode();
    }

    private static Set<String> extractColumnIds(List<GridCustomColumn> columns) {
        HashSet<String> result = new HashSet<String>();
        for (GridCustomColumn column : columns) {
            result.add(AbstractColumnSettingsDataModelProvider.getId(column));
        }
        return result;
    }

    private static ColumnDataModel createColumnDataModel(GridCustomColumn column) {
        return new ColumnDataModel(column.getName(), true, false, AbstractColumnSettingsDataModelProvider.getId(column));
    }

    private int tryFindColumnIx(String columnId) {
        int i = 0;
        while (i < this.columnDataModels.size()) {
            ColumnDataModel columnDataModel = this.columnDataModels.get(i);
            if (columnDataModel.getColumnID().equals(columnId)) {
                return i;
            }
            ++i;
        }
        return -1;
    }
}

