/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid;

import ch.systemsx.cisd.openbis.generic.client.web.client.ICommonClientServiceAsync;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.help.HelpPageIdentifier;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.AbstractColumnSettingsDataModelProvider;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.ColumnSettingsChooser;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.IDisposableComponent;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.expressions.column.GridCustomColumnGrid;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.expressions.filter.GridCustomFilterGrid;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.DialogWithOnlineHelpUtils;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.IDelegatedAction;
import com.extjs.gxt.ui.client.event.ButtonEvent;
import com.extjs.gxt.ui.client.event.Events;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.event.SelectionListener;
import com.extjs.gxt.ui.client.event.TabPanelEvent;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.Dialog;
import com.extjs.gxt.ui.client.widget.Layout;
import com.extjs.gxt.ui.client.widget.TabItem;
import com.extjs.gxt.ui.client.widget.TabPanel;
import com.extjs.gxt.ui.client.widget.Window;
import com.extjs.gxt.ui.client.widget.button.Button;
import com.extjs.gxt.ui.client.widget.layout.FitLayout;
import com.google.gwt.user.client.ui.Widget;

public class ColumnSettingsDialog
extends Dialog {
    public static final String TAB_PANEL_ID_PREFIX = "openbis_tab-panel";
    public static final String FILTERS_TAB = "openbis_filters-tab";
    public static final String COLUMNS_TAB = "openbis_columns-tab";
    private final IViewContext<ICommonClientServiceAsync> viewContext;
    private final String gridDisplayId;

    public static void show(IViewContext<ICommonClientServiceAsync> viewContext, AbstractColumnSettingsDataModelProvider columnDataModelProvider, String gridDisplayId) {
        new ColumnSettingsDialog(viewContext, gridDisplayId).show(columnDataModelProvider);
    }

    private ColumnSettingsDialog(IViewContext<ICommonClientServiceAsync> viewContext, String gridId) {
        this.viewContext = viewContext;
        this.gridDisplayId = gridId;
        this.setHeight(450);
        this.setWidth(700);
        this.setLayout((Layout)new FitLayout());
        this.setButtons("ok");
        this.setHeading(viewContext.getMessage("grid_settings_title", new Object[0]));
        this.setModal(true);
        DialogWithOnlineHelpUtils.addHelpButton(viewContext, (Window)this, this.createHelpPageIdentifier());
    }

    private void show(final AbstractColumnSettingsDataModelProvider columnDataModelProvider) {
        IDelegatedAction onCloseAction;
        assert (columnDataModelProvider != null) : "columnDataModelProvider not specified";
        this.removeAll();
        TabPanel panel = new TabPanel();
        panel.setId(TAB_PANEL_ID_PREFIX + this.gridDisplayId);
        final ColumnSettingsChooser columnChooser = new ColumnSettingsChooser(columnDataModelProvider, this.viewContext);
        TabItem columnsTab = this.createTabItem(columnChooser.getComponent(), "columns", "");
        columnsTab.addListener(Events.Select, (Listener)new Listener<TabPanelEvent>(){

            public final void handleEvent(TabPanelEvent be) {
                columnChooser.refresh();
            }
        });
        panel.add(columnsTab);
        if (!this.viewContext.isSimpleOrEmbeddedMode()) {
            final IDisposableComponent columns = GridCustomColumnGrid.create(this.viewContext, this.gridDisplayId, columnDataModelProvider);
            TabItem customColumnsTab = this.createTabItem(columns.getComponent(), "grid_custom_columns", COLUMNS_TAB);
            panel.add(customColumnsTab);
            final IDisposableComponent filters = GridCustomFilterGrid.create(this.viewContext, this.gridDisplayId, columnDataModelProvider);
            TabItem customFiltersTab = this.createTabItem(filters.getComponent(), "grid_custom_filters", FILTERS_TAB);
            panel.add(customFiltersTab);
            onCloseAction = new IDelegatedAction(){

                @Override
                public void execute() {
                    columnDataModelProvider.onClose(columnChooser.getModels());
                    ColumnSettingsDialog.this.hide();
                    filters.dispose();
                    columns.dispose();
                }
            };
        } else {
            onCloseAction = new IDelegatedAction(){

                @Override
                public void execute() {
                    columnDataModelProvider.onClose(columnChooser.getModels());
                    ColumnSettingsDialog.this.hide();
                }
            };
        }
        this.add((Component)panel);
        super.show();
        Button okButton = this.getButtonById("ok");
        okButton.setId("ok" + this.gridDisplayId);
        okButton.addListener(Events.Select, (Listener)new SelectionListener<ButtonEvent>(){

            public void componentSelected(ButtonEvent ce) {
                onCloseAction.execute();
            }
        });
    }

    private TabItem createTabItem(Component component, String titleDictKey, String tabIdPrefix) {
        TabItem customColumnsTab = new TabItem(this.viewContext.getMessage(titleDictKey, new Object[0]));
        customColumnsTab.setId(String.valueOf(tabIdPrefix) + this.gridDisplayId);
        customColumnsTab.setLayout((Layout)new FitLayout());
        customColumnsTab.add((Widget)component);
        return customColumnsTab;
    }

    protected HelpPageIdentifier createHelpPageIdentifier() {
        return new HelpPageIdentifier(HelpPageIdentifier.HelpPageDomain.TABLE_SETTINGS, HelpPageIdentifier.HelpPageAction.ACTION);
    }
}

