/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.listener;

import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.AbstractTabItemFactory;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.DispatcherHelper;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.plugin.IClientPlugin;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.plugin.IClientPluginFactory;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.IDelegatedAction;
import ch.systemsx.cisd.openbis.generic.shared.basic.IEntityInformationHolderWithPermId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.BasicEntityType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind;

public final class OpenEntityDetailsTabAction
implements IDelegatedAction {
    private final IEntityInformationHolderWithPermId entity;
    private final IViewContext<?> viewContext;
    private final boolean keyPressed;

    public OpenEntityDetailsTabAction(IEntityInformationHolderWithPermId entity, IViewContext<?> viewContext) {
        this(entity, viewContext, false);
    }

    public OpenEntityDetailsTabAction(IEntityInformationHolderWithPermId entity, IViewContext<?> viewContext, boolean keyPressed) {
        this.entity = entity;
        this.viewContext = viewContext;
        this.keyPressed = keyPressed;
    }

    @Override
    public void execute() {
        EntityKind entityKind = this.entity.getEntityKind();
        BasicEntityType entityType = this.entity.getEntityType();
        IClientPluginFactory clientPluginFactory = this.viewContext.getClientPluginFactoryProvider().getClientPluginFactory(entityKind, entityType);
        IClientPlugin createClientPlugin = clientPluginFactory.createClientPlugin(entityKind);
        AbstractTabItemFactory tabView = createClientPlugin.createEntityViewer(this.entity);
        tabView.setInBackground(this.keyPressed);
        DispatcherHelper.dispatchNaviEvent(tabView);
    }
}

