/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.script;

import ch.systemsx.cisd.openbis.generic.client.web.client.ICommonClientServiceAsync;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.AbstractAsyncCallback;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.AbstractTabItemFactory;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.ComponentProvider;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.DefaultTabItem;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.DispatcherHelper;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.DisplayTypeIDGenerator;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.ITabItem;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.help.HelpPageIdentifier;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.model.BaseEntityModel;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.TypedTableGrid;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.ColumnDefsAndConfigs;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.DisposableEntityChooser;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.IBrowserGridActionInvoker;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.script.AbstractScriptEditRegisterForm;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.script.ScriptEditForm;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.AbstractDataListPermanentDeletionConfirmationDialog;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.DefaultResultSetConfig;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.ListScriptsCriteria;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.TableExportCriteria;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.TypedTableResultSet;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DatabaseModificationKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Script;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ScriptType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModelRowWithObject;
import com.extjs.gxt.ui.client.event.ButtonEvent;
import com.extjs.gxt.ui.client.event.SelectionListener;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.Dialog;
import com.extjs.gxt.ui.client.widget.button.Button;
import com.google.gwt.user.client.rpc.AsyncCallback;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class ScriptGrid
extends TypedTableGrid<Script> {
    public static final String BROWSER_ID = "openbis_script-browser";
    public static final String GRID_ID = "openbis_script-browser-grid";
    public static final String ADD_BUTTON_ID = "openbis_script-browser_add-button";
    public static final String DELETE_BUTTON_ID = "openbis_script-browser_delete-button";
    public static final String EDIT_BUTTON_ID = "openbis_script-browser-edit-button";
    private final EntityKind entityKindOrNull;
    private final ScriptType scriptTypeOrNull;

    public static DisposableEntityChooser<TableModelRowWithObject<Script>> create(IViewContext<ICommonClientServiceAsync> viewContext, ScriptType scriptTypeOrNull, EntityKind entityKindOrNull) {
        ScriptGrid grid = new ScriptGrid(viewContext, scriptTypeOrNull, entityKindOrNull);
        grid.extendBottomToolbar();
        return grid.asDisposableWithoutToolbar();
    }

    private ScriptGrid(IViewContext<ICommonClientServiceAsync> viewContext, ScriptType scriptTypeOrNull, EntityKind entityKindOrNull) {
        super(viewContext, BROWSER_ID, true, DisplayTypeIDGenerator.SCRIPTS_BROWSER_GRID);
        this.entityKindOrNull = entityKindOrNull;
        this.scriptTypeOrNull = scriptTypeOrNull;
    }

    private void extendBottomToolbar() {
        this.addEntityOperationsLabel();
        Button addScriptButton = new Button(this.viewContext.getMessage("button_add", this.viewContext.getMessage("plugin", new Object[0])), (SelectionListener)new SelectionListener<ButtonEvent>(){

            public void componentSelected(ButtonEvent ce) {
                DispatcherHelper.dispatchNaviEvent(new ComponentProvider(ScriptGrid.this.viewContext).getScriptRegistration(ScriptGrid.this.entityKindOrNull));
            }
        });
        addScriptButton.setId(ADD_BUTTON_ID);
        this.addButton(addScriptButton);
        Button editButton = this.createSelectedItemButton(this.viewContext.getMessage("edit", new Object[0]), new TypedTableGrid.ISelectedEntityInvoker<BaseEntityModel<TableModelRowWithObject<Script>>>(){

            @Override
            public void invoke(BaseEntityModel<TableModelRowWithObject<Script>> selectedItem, boolean keyPressed) {
                ScriptGrid.this.openEditor(selectedItem, keyPressed);
            }
        });
        editButton.setId(EDIT_BUTTON_ID);
        this.addButton(editButton);
        Button deleteButton = this.createSelectedItemsButton(this.viewContext.getMessage("button_delete", new Object[0]), new TypedTableGrid.AbstractCreateDialogListener(this){

            protected Dialog createDialog(List<TableModelRowWithObject<Script>> scripts, IBrowserGridActionInvoker invoker) {
                return new ScriptListDeletionConfirmationDialog(ScriptGrid.this.viewContext, scripts, ScriptGrid.this.createRefreshCallback(invoker));
            }
        });
        this.addButton(deleteButton);
        this.allowMultipleSelection();
        this.addEntityOperationsSeparator();
    }

    @Override
    protected String translateColumnIdToDictionaryKey(String columnID) {
        return columnID.toLowerCase();
    }

    @Override
    protected ColumnDefsAndConfigs<TableModelRowWithObject<Script>> createColumnsDefinition() {
        ColumnDefsAndConfigs<TableModelRowWithObject<Script>> schema = super.createColumnsDefinition();
        schema.setGridCellRendererFor("DESCRIPTION", this.createMultilineStringCellRenderer());
        schema.setGridCellRendererFor("SCRIPT", this.createMultilineStringCellRenderer());
        return schema;
    }

    @Override
    protected void listTableRows(DefaultResultSetConfig<String, TableModelRowWithObject<Script>> resultSetConfig, AbstractAsyncCallback<TypedTableResultSet<Script>> callback) {
        ListScriptsCriteria criteria = new ListScriptsCriteria();
        criteria.copyPagingConfig(resultSetConfig);
        criteria.setScriptType(this.scriptTypeOrNull);
        criteria.setEntityKind(this.entityKindOrNull);
        ((ICommonClientServiceAsync)this.viewContext.getService()).listScripts(criteria, callback);
    }

    @Override
    protected void prepareExportEntities(TableExportCriteria<TableModelRowWithObject<Script>> exportCriteria, AbstractAsyncCallback<String> callback) {
        ((ICommonClientServiceAsync)this.viewContext.getService()).prepareExportScripts(exportCriteria, callback);
    }

    @Override
    protected List<String> getColumnIdsOfFilters() {
        return Arrays.asList("NAME");
    }

    @Override
    public DatabaseModificationKind[] getRelevantModifications() {
        return new DatabaseModificationKind[]{DatabaseModificationKind.createOrDelete(DatabaseModificationKind.ObjectKind.SCRIPT), DatabaseModificationKind.edit(DatabaseModificationKind.ObjectKind.SCRIPT)};
    }

    private void openEditor(BaseEntityModel<TableModelRowWithObject<Script>> selectedItem, boolean keyPressed) {
        Script script = selectedItem.getBaseObject().getObjectOrNull();
        final TechId scriptId = TechId.create(script);
        AbstractTabItemFactory tabFactory = new AbstractTabItemFactory(){

            @Override
            public ITabItem create() {
                Component component = ScriptEditForm.create(ScriptGrid.this.viewContext, scriptId);
                return DefaultTabItem.createUnaware(this.getTabTitle(), component, true, ScriptGrid.this.viewContext);
            }

            @Override
            public String getId() {
                return AbstractScriptEditRegisterForm.createId(scriptId);
            }

            @Override
            public String getTabTitle() {
                return ScriptGrid.this.viewContext.getMessage("edit_title", ScriptGrid.this.viewContext.getMessage("plugin", new Object[0]), "");
            }

            @Override
            public HelpPageIdentifier getHelpPageIdentifier() {
                return new HelpPageIdentifier(HelpPageIdentifier.HelpPageDomain.SCRIPT, HelpPageIdentifier.HelpPageAction.EDIT);
            }

            @Override
            public String tryGetLink() {
                return null;
            }
        };
        tabFactory.setInBackground(keyPressed);
        DispatcherHelper.dispatchNaviEvent(tabFactory);
    }

    private static final class ScriptListDeletionConfirmationDialog
    extends AbstractDataListPermanentDeletionConfirmationDialog<TableModelRowWithObject<Script>> {
        public ScriptListDeletionConfirmationDialog(IViewContext<ICommonClientServiceAsync> viewContext, List<TableModelRowWithObject<Script>> data, AbstractAsyncCallback<Void> callback) {
            super(viewContext, data, callback);
        }

        @Override
        protected void executeDeletion(AsyncCallback<Void> deletionCallback) {
            this.viewContext.getCommonService().deleteScripts(TechId.createList((Collection)this.data), deletionCallback);
        }

        @Override
        protected String getEntityName() {
            return this.messageProvider.getMessage("plugin", new Object[0]);
        }
    }
}

