/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.util.log;

import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.log.IProfilingTable;
import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.event.ButtonEvent;
import com.extjs.gxt.ui.client.event.SelectionListener;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.ContentPanel;
import com.extjs.gxt.ui.client.widget.Label;
import com.extjs.gxt.ui.client.widget.VerticalPanel;
import com.extjs.gxt.ui.client.widget.button.Button;
import com.google.gwt.user.client.ui.Widget;
import java.util.List;

public class LoggingConsole {
    public static final String ID = "openbis_LoggingConsole";

    public static Component create(final IProfilingTable profilingTable) {
        final ContentPanel mainPanel = new ContentPanel();
        mainPanel.setScrollMode(Style.Scroll.AUTO);
        mainPanel.add(LoggingConsole.createContent(profilingTable));
        Button clearButton = new Button("Clear");
        clearButton.addSelectionListener((SelectionListener)new SelectionListener<ButtonEvent>(){

            public void componentSelected(ButtonEvent ce) {
                profilingTable.clearLog();
                mainPanel.removeAll();
            }
        });
        mainPanel.addButton(clearButton);
        Button refreshButton = new Button("Refresh");
        refreshButton.addSelectionListener((SelectionListener)new SelectionListener<ButtonEvent>(){

            public void componentSelected(ButtonEvent ce) {
                mainPanel.removeAll();
                mainPanel.add(LoggingConsole.createContent(profilingTable));
                mainPanel.layout();
            }
        });
        mainPanel.addButton(refreshButton);
        return mainPanel;
    }

    private static Widget createContent(IProfilingTable profilingTable) {
        VerticalPanel panel = new VerticalPanel();
        List<String> events = profilingTable.getLoggedEvents();
        panel.add((Widget)new Label("The header is: start-timestamp [stop-timestamp: duration] description"));
        for (String event : events) {
            panel.add((Widget)new Label(event));
        }
        return panel;
    }
}

