/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.server.resultset;

import ch.systemsx.cisd.common.shared.basic.string.CommaSeparatedListBuilder;
import ch.systemsx.cisd.openbis.generic.client.web.server.resultset.AbstractCommonTableModelProvider;
import ch.systemsx.cisd.openbis.generic.shared.ICommonServer;
import ch.systemsx.cisd.openbis.generic.shared.basic.SimpleYesNoRenderer;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Script;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ScriptType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TypedTableModel;
import ch.systemsx.cisd.openbis.generic.shared.util.TypedTableModelBuilder;
import java.util.List;

public class ScriptProvider
extends AbstractCommonTableModelProvider<Script> {
    private final ScriptType scriptTypeOrNull;
    private final EntityKind entityKindOrNull;

    public ScriptProvider(ICommonServer commonServer, String sessionToken, ScriptType scriptTypeOrNull, EntityKind entityKindOrNull) {
        super(commonServer, sessionToken);
        this.scriptTypeOrNull = scriptTypeOrNull;
        this.entityKindOrNull = entityKindOrNull;
    }

    @Override
    protected TypedTableModel<Script> createTableModel() {
        List<Script> scripts = this.commonServer.listScripts(this.sessionToken, this.scriptTypeOrNull, this.entityKindOrNull);
        TypedTableModelBuilder<Script> builder = new TypedTableModelBuilder<Script>();
        builder.addColumn("NAME");
        builder.addColumn("DESCRIPTION");
        builder.addColumn("SCRIPT");
        builder.addColumn("ENTITY_KIND");
        builder.addColumn("SCRIPT_TYPE");
        builder.addColumn("PLUGIN_TYPE");
        builder.addColumn("REGISTRATOR");
        builder.addColumn("MODIFICATION_DATE").withDefaultWidth(300).hideByDefault();
        builder.addColumn("IS_AVAILABLE");
        for (Script script : scripts) {
            builder.addRow(script);
            builder.column("NAME").addString(script.getName());
            builder.column("DESCRIPTION").addString(script.getDescription());
            builder.column("SCRIPT").addString(script.getScript());
            builder.column("ENTITY_KIND").addString(ScriptProvider.buildDescription(script.getEntityKind()));
            builder.column("SCRIPT_TYPE").addString(script.getScriptType().getDescription());
            builder.column("PLUGIN_TYPE").addString(script.getPluginType().getDescription());
            builder.column("REGISTRATOR").addPerson(script.getRegistrator());
            builder.column("MODIFICATION_DATE").addDate(script.getModificationDate());
            builder.column("IS_AVAILABLE").addString(SimpleYesNoRenderer.render(script.isAvailable()));
        }
        return builder.getModel();
    }

    private static String buildDescription(EntityKind[] entityKinds) {
        if (entityKinds == null) {
            return "All";
        }
        if (entityKinds.length == 1) {
            return entityKinds[0].getDescription();
        }
        CommaSeparatedListBuilder builder = new CommaSeparatedListBuilder();
        EntityKind[] entityKindArray = entityKinds;
        int n = entityKinds.length;
        int n2 = 0;
        while (n2 < n) {
            EntityKind entityKind = entityKindArray[n2];
            builder.append(entityKind.getDescription());
            ++n2;
        }
        return builder.toString();
    }
}

