/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.business.bo.materiallister;

import ch.rinn.restrictions.Private;
import ch.systemsx.cisd.openbis.generic.server.business.bo.common.GenericEntityPropertyRecord;
import ch.systemsx.cisd.openbis.generic.server.business.bo.common.IPropertyListingQuery;
import ch.systemsx.cisd.openbis.generic.server.business.bo.common.MaterialEntityPropertyRecord;
import ch.systemsx.cisd.openbis.generic.server.business.bo.common.VocabularyTermRecord;
import ch.systemsx.cisd.openbis.generic.server.business.bo.fetchoptions.common.MetaProjectWithEntityId;
import ch.systemsx.cisd.openbis.generic.server.business.bo.materiallister.MaterialRecord;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.LongSetMapper;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.StringArrayMapper;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.List;
import net.lemnik.eodsql.BaseQuery;
import net.lemnik.eodsql.DataIterator;
import net.lemnik.eodsql.Select;
import net.lemnik.eodsql.TypeMapper;

@Private
public interface IMaterialListingQuery
extends BaseQuery,
IPropertyListingQuery {
    public static final int FETCH_SIZE = 1000;
    public static final String SELECT_MATERIALS = "select m.id, m.code, m.dbin_id, m.maty_id, m.registration_timestamp, m.modification_timestamp, m.pers_id_registerer from materials m";
    public static final String SELECT_MATERIALS_WHERE = "select m.id, m.code, m.dbin_id, m.maty_id, m.registration_timestamp, m.modification_timestamp, m.pers_id_registerer from materials m where";

    @Select(sql="select m.id, m.code, m.dbin_id, m.maty_id, m.registration_timestamp, m.modification_timestamp, m.pers_id_registerer from materials m where m.dbin_id=?{1} and m.maty_id=?{2} order by m.code", fetchSize=1000)
    public DataIterator<MaterialRecord> getMaterialsForMaterialType(long var1, long var3);

    @Select(sql="select m.id, m.code, m.dbin_id, m.maty_id, m.registration_timestamp, m.modification_timestamp, m.pers_id_registerer from materials m where m.dbin_id=?{1} and m.id = any(?{2}) order by m.code", parameterBindings={TypeMapper.class, LongSetMapper.class}, fetchSize=1000)
    public DataIterator<MaterialRecord> getMaterialsForMaterialTypeWithIds(long var1, LongSet var3);

    @Select(sql="select m.id, m.code, m.dbin_id, m.maty_id, m.registration_timestamp, m.modification_timestamp, m.pers_id_registerer from materials m where m.dbin_id=?{1} and m.code = any(?{2}) order by m.code", parameterBindings={TypeMapper.class, StringArrayMapper.class}, fetchSize=1000)
    public DataIterator<MaterialRecord> getMaterialsForMaterialCodes(long var1, String[] var3);

    @Select(sql="select m.id, m.code, m.dbin_id, m.maty_id, m.registration_timestamp, m.modification_timestamp, m.pers_id_registerer from materials m JOIN metaproject_assignments ma ON m.id=ma.mate_id WHERE m.dbin_id=?{1} AND ma.mepr_id=?{2} order by m.code", fetchSize=1000)
    public DataIterator<MaterialRecord> getMaterialsForMetaprojectId(long var1, long var3);

    @Select(sql="SELECT pr.mate_id as entity_id, etpt.prty_id, etpt.script_id, pr.value, sc.script_type       FROM material_properties pr      JOIN material_type_property_types etpt ON pr.mtpt_id=etpt.id      LEFT OUTER JOIN scripts sc ON etpt.script_id = sc.id     WHERE pr.value is not null AND pr.mate_id = any(?{1})", parameterBindings={LongSetMapper.class}, fetchSize=1000)
    public DataIterator<GenericEntityPropertyRecord> getEntityPropertyGenericValues(LongSet var1);

    @Select(sql="SELECT pr.mate_id as entity_id, etpt.prty_id, etpt.script_id, cvte.id, cvte.covo_id, cvte.code, cvte.label, cvte.ordinal, cvte.is_official, cvte.description      FROM material_properties pr      JOIN material_type_property_types etpt ON pr.mtpt_id=etpt.id      JOIN controlled_vocabulary_terms cvte ON pr.cvte_id=cvte.id     WHERE pr.cvte_id is not null AND pr.mate_id = any(?{1})", parameterBindings={LongSetMapper.class}, fetchSize=1000)
    public DataIterator<VocabularyTermRecord> getEntityPropertyVocabularyTermValues(LongSet var1);

    @Select(sql="SELECT pr.mate_id as entity_id, etpt.prty_id, etpt.script_id, m.id, m.code, m.maty_id      FROM material_properties pr      JOIN material_type_property_types etpt ON pr.mtpt_id=etpt.id      JOIN materials m ON pr.mate_prop_id=m.id      WHERE pr.mate_prop_id is not null AND pr.mate_id = any(?{1})", parameterBindings={LongSetMapper.class}, fetchSize=1000)
    public DataIterator<MaterialEntityPropertyRecord> getEntityPropertyMaterialValues(LongSet var1);

    @Select(sql="select m.id as id, m.name as name, m.description as description, p.user_id as owner_name,  m.private as is_private, m.creation_date as creation_date, ma.mate_id as entity_id  from metaprojects m, metaproject_assignments ma, persons p  where ma.mate_id = any(?{1}) and m.owner = ?{2} and m.id = ma.mepr_id and m.owner = p.id", parameterBindings={LongSetMapper.class}, fetchSize=1000)
    public List<MetaProjectWithEntityId> getMetaprojects(LongSet var1, Long var2);
}

