/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.dto;

import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataSetArchivingStatus;
import ch.systemsx.cisd.openbis.generic.shared.dto.DeletedDataPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.hibernate.Location;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.PrimaryKeyJoinColumn;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;
import javax.validation.constraints.NotNull;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="external_data", uniqueConstraints={@UniqueConstraint(columnNames={"location", "loty_id"})})
@PrimaryKeyJoinColumn(name="data_id")
public final class DeletedExternalDataPE
extends DeletedDataPE {
    private static final long serialVersionUID = 35L;
    private String location;
    private DataSetArchivingStatus status = DataSetArchivingStatus.AVAILABLE;
    private boolean isPresentInArchive;

    @Column(name="location")
    @Length(max=1024, message="Given location '%s' is too long (maximal length: {max} characters).")
    @NotNull(message="Location can not be null.")
    @Location(relative=true, message="Location is not relative")
    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    @NotNull(message="Status can not be null.")
    @Column(name="status")
    @Enumerated(value=EnumType.STRING)
    public DataSetArchivingStatus getStatus() {
        return this.status;
    }

    public void setStatus(DataSetArchivingStatus status) {
        this.status = status;
    }

    @Column(name="present_in_archive")
    public boolean isPresentInArchive() {
        return this.isPresentInArchive;
    }

    public void setPresentInArchive(boolean isPresentInArchive) {
        this.isPresentInArchive = isPresentInArchive;
    }

    @Override
    @Transient
    public boolean isAvailable() {
        return this.getStatus().isAvailable();
    }

    @Override
    @Transient
    public boolean isDeletable() {
        return this.getStatus().isDeletable();
    }
}

