/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.generic.client.web.client.application.material;

import ch.systemsx.cisd.openbis.generic.client.web.client.ICommonClientServiceAsync;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.AbstractAsyncCallback;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.DatabaseModificationAwareComponent;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.DatabaseModificationAwareField;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.IDatabaseModificationObserver;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.AbstractRegistrationForm;
import ch.systemsx.cisd.openbis.generic.shared.basic.IIdAndCodeHolder;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Material;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.MaterialType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.MaterialTypePropertyType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.api.IManagedInputWidgetDescription;
import ch.systemsx.cisd.openbis.plugin.generic.client.web.client.IGenericClientServiceAsync;
import ch.systemsx.cisd.openbis.plugin.generic.client.web.client.application.AbstractGenericEntityRegistrationForm;
import ch.systemsx.cisd.openbis.plugin.generic.client.web.client.application.experiment.PropertiesEditor;
import ch.systemsx.cisd.openbis.plugin.generic.client.web.client.application.material.MaterialPropertyEditor;
import com.extjs.gxt.ui.client.widget.Component;
import com.google.gwt.user.client.rpc.AsyncCallback;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

public final class GenericMaterialEditForm
extends AbstractGenericEntityRegistrationForm<MaterialType, MaterialTypePropertyType> {
    private Material originalMaterial;

    public static DatabaseModificationAwareComponent create(IViewContext<IGenericClientServiceAsync> viewContext, IIdAndCodeHolder identifiable, boolean editMode) {
        GenericMaterialEditForm form = new GenericMaterialEditForm(viewContext, identifiable, editMode);
        return new DatabaseModificationAwareComponent((Component)form, (IDatabaseModificationObserver)form);
    }

    private GenericMaterialEditForm(IViewContext<IGenericClientServiceAsync> viewContext, IIdAndCodeHolder identifiable, boolean editMode) {
        super(viewContext, null, identifiable, EntityKind.MATERIAL);
        this.setRevertButtonVisible(true);
    }

    @Override
    public final void submitValidForm() {
        ((IGenericClientServiceAsync)this.viewContext.getService()).updateMaterial(this.techIdOrNull, this.extractProperties(), this.metaprojectArea.tryGetModifiedMetaprojects(), this.originalMaterial.getModificationDate(), new UpdateMaterialCallback(this.viewContext));
    }

    public void updateOriginalValues() {
        this.updatePropertyFieldsOriginalValues();
        this.updateFieldOriginalValue(this.metaprojectArea);
    }

    @Override
    protected PropertiesEditor<MaterialType, MaterialTypePropertyType> createPropertiesEditor(String id, Map<String, List<IManagedInputWidgetDescription>> inputWidgetDescriptions, IViewContext<ICommonClientServiceAsync> context) {
        MaterialPropertyEditor editor = new MaterialPropertyEditor(id, inputWidgetDescriptions, context);
        return editor;
    }

    @Override
    protected List<DatabaseModificationAwareField<?>> getEntitySpecificFormFields() {
        return new ArrayList();
    }

    @Override
    protected void createEntitySpecificFormFields() {
    }

    @Override
    protected void initializeFormFields() {
        this.propertiesEditor.initWithProperties(this.originalMaterial.getMaterialType().getAssignedPropertyTypes(), this.originalMaterial.getProperties());
        this.codeField.setValue(this.originalMaterial.getCode());
        this.metaprojectArea.setMetaprojects(this.originalMaterial.getMetaprojects());
    }

    private void setOriginalMaterial(Material material) {
        this.originalMaterial = material;
    }

    @Override
    protected void loadForm() {
        this.viewContext.getCommonService().getMaterialInfo(this.techIdOrNull, (AsyncCallback<Material>)new MaterialInfoCallback(this.viewContext));
    }

    private final class MaterialInfoCallback
    extends AbstractAsyncCallback<Material> {
        private MaterialInfoCallback(IViewContext<IGenericClientServiceAsync> viewContext) {
            super(viewContext);
        }

        @Override
        protected final void process(Material result) {
            GenericMaterialEditForm.this.setOriginalMaterial(result);
            GenericMaterialEditForm.this.initGUI();
        }
    }

    private final class UpdateMaterialCallback
    extends AbstractRegistrationForm.AbstractRegistrationCallback<Date> {
        UpdateMaterialCallback(IViewContext<?> viewContext) {
            super(viewContext);
        }

        @Override
        protected void process(Date result) {
            GenericMaterialEditForm.this.originalMaterial.setModificationDate(result);
            GenericMaterialEditForm.this.updateOriginalValues();
            super.process(result);
        }

        @Override
        protected String createSuccessfullRegistrationInfo(Date result) {
            return "Material successfully updated";
        }
    }
}

