/*
 * Decompiled with CFR 0.152.
 */
package ar.com.hjg.pngj;

import ar.com.hjg.pngj.ImageInfo;
import ar.com.hjg.pngj.ImageLine;
import ar.com.hjg.pngj.PngFilterType;
import ar.com.hjg.pngj.PngHelper;
import ar.com.hjg.pngj.PngIDatChunkInputStream;
import ar.com.hjg.pngj.PngjInputException;
import ar.com.hjg.pngj.PngjUnsupportedException;
import ar.com.hjg.pngj.chunks.ChunkHelper;
import ar.com.hjg.pngj.chunks.ChunkList;
import ar.com.hjg.pngj.chunks.ChunkLoadBehaviour;
import ar.com.hjg.pngj.chunks.ChunkRaw;
import ar.com.hjg.pngj.chunks.PngChunk;
import ar.com.hjg.pngj.chunks.PngChunkIHDR;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.zip.InflaterInputStream;

public class PngReader {
    public final ImageInfo imgInfo;
    private final String filename;
    private final InputStream is;
    private final InflaterInputStream idatIstream;
    private final PngIDatChunkInputStream iIdatCstream;
    private int offset = 0;
    private static int MAX_BYTES_CHUNKS_TO_LOAD = 640000;
    private int bytesChunksLoaded;
    private ChunkLoadBehaviour chunkLoadBehaviour = ChunkLoadBehaviour.LOAD_CHUNK_ALWAYS;
    private int rowNum = -1;
    private ImageLine imgLine;
    private int[] rowb = null;
    private int[] rowbprev = null;
    private byte[] rowbfilter = null;
    public ChunkList chunks = new ChunkList();
    private List<FoundChunkInfo> foundChunksInfo = new ArrayList<FoundChunkInfo>();

    public PngReader(InputStream inputStream, String filenameOrDescription) {
        boolean grayscale;
        this.filename = filenameOrDescription == null ? "" : filenameOrDescription;
        this.is = inputStream;
        byte[] pngid = new byte[PngHelper.pngIdBytes.length];
        PngHelper.readBytes(this.is, pngid, 0, pngid.length);
        this.offset += pngid.length;
        if (!Arrays.equals(pngid, PngHelper.pngIdBytes)) {
            throw new PngjInputException("Bad PNG signature");
        }
        int clen = PngHelper.readInt4(this.is);
        this.offset += 4;
        if (clen != 13) {
            throw new RuntimeException("IDHR chunk len != 13 ?? " + clen);
        }
        byte[] chunkid = new byte[4];
        PngHelper.readBytes(this.is, chunkid, 0, 4);
        if (!Arrays.equals(chunkid, ChunkHelper.IHDR)) {
            throw new PngjInputException("IHDR not found as first chunk??? [" + ChunkHelper.toString(chunkid) + "]");
        }
        this.offset += 4;
        ChunkRaw chunk = new ChunkRaw(clen, chunkid, true);
        String chunkids = ChunkHelper.toString(chunkid);
        this.foundChunksInfo.add(new FoundChunkInfo(chunkids, clen, this.offset - 8, true));
        this.offset += chunk.readChunkData(this.is);
        PngChunkIHDR ihdr = (PngChunkIHDR)this.addChunkToList(chunk);
        if (ihdr.interlaced != 0) {
            throw new PngjUnsupportedException("PNG interlaced not supported by this library");
        }
        if (ihdr.filmeth != 0 || ihdr.compmeth != 0) {
            throw new PngjInputException("compmethod o filtermethod unrecognized");
        }
        boolean alpha = (ihdr.colormodel & 4) != 0;
        boolean palette = (ihdr.colormodel & 1) != 0;
        boolean bl = grayscale = ihdr.colormodel == 0 || ihdr.colormodel == 4;
        if (ihdr.colormodel < 0 || ihdr.colormodel > 6 || ihdr.colormodel == 1 || ihdr.colormodel == 5) {
            throw new PngjInputException("Invalid colormodel " + ihdr.colormodel);
        }
        if (ihdr.bitspc != 1 && ihdr.bitspc != 2 && ihdr.bitspc != 4 && ihdr.bitspc != 8 && ihdr.bitspc != 16) {
            throw new PngjInputException("Invalid bit depth " + ihdr.bitspc);
        }
        this.imgInfo = new ImageInfo(ihdr.cols, ihdr.rows, ihdr.bitspc, alpha, grayscale, palette);
        this.imgLine = new ImageLine(this.imgInfo);
        this.rowb = new int[this.imgInfo.bytesPerRow + 1];
        this.rowbprev = new int[this.rowb.length];
        this.rowbfilter = new byte[this.rowb.length];
        int idatLen = this.readFirstChunks();
        if (idatLen < 0) {
            throw new PngjInputException("first idat chunk not found!");
        }
        this.iIdatCstream = new PngIDatChunkInputStream(this.is, idatLen, this.offset);
        this.idatIstream = new InflaterInputStream(this.iIdatCstream);
    }

    private PngChunk addChunkToList(ChunkRaw chunk) {
        PngChunk chunkType = PngChunk.factory(chunk, this.imgInfo);
        if (!chunkType.crit) {
            this.bytesChunksLoaded += chunk.len;
        }
        if (this.bytesChunksLoaded > MAX_BYTES_CHUNKS_TO_LOAD) {
            throw new PngjInputException("Chunk exceeded available space (" + MAX_BYTES_CHUNKS_TO_LOAD + ") chunk: " + chunk + " See PngReader.MAX_BYTES_CHUNKS_TO_LOAD\n");
        }
        this.chunks.appendChunk(chunkType);
        return chunkType;
    }

    private int readFirstChunks() {
        int clen = 0;
        boolean found = false;
        byte[] chunkid = new byte[4];
        while (!found) {
            ChunkRaw chunk;
            clen = PngHelper.readInt4(this.is);
            this.offset += 4;
            if (clen < 0) break;
            PngHelper.readBytes(this.is, chunkid, 0, 4);
            this.offset += 4;
            if (Arrays.equals(chunkid, ChunkHelper.IDAT)) {
                found = true;
                chunk = new ChunkRaw(0, chunkid, false);
                this.addChunkToList(chunk);
                break;
            }
            if (Arrays.equals(chunkid, ChunkHelper.IEND)) {
                throw new PngjInputException("END chunk found before image data (IDAT) at offset=" + this.offset);
            }
            chunk = new ChunkRaw(clen, chunkid, true);
            String chunkids = ChunkHelper.toString(chunkid);
            boolean loadchunk = ChunkHelper.shouldLoad(chunkids, this.chunkLoadBehaviour);
            this.foundChunksInfo.add(new FoundChunkInfo(chunkids, clen, this.offset - 8, loadchunk));
            this.offset += chunk.readChunkData(this.is);
            if (!loadchunk) continue;
            this.addChunkToList(chunk);
        }
        return found ? clen : -1;
    }

    private void readLastChunks() {
        if (!this.iIdatCstream.isEnded()) {
            this.iIdatCstream.forceChunkEnd();
        }
        for (PngIDatChunkInputStream.IdatChunkInfo idat : this.iIdatCstream.foundChunksInfo) {
            this.foundChunksInfo.add(new FoundChunkInfo("IDAT", idat.len, idat.offset, true));
        }
        int clen = this.iIdatCstream.getLenLastChunk();
        byte[] chunkid = this.iIdatCstream.getIdLastChunk();
        boolean endfound = false;
        boolean first = true;
        boolean ignore = false;
        while (!endfound) {
            ignore = false;
            if (!first) {
                clen = PngHelper.readInt4(this.is);
                this.offset += 4;
                if (clen < 0) {
                    throw new PngjInputException("bad len " + clen);
                }
                PngHelper.readBytes(this.is, chunkid, 0, 4);
                this.offset += 4;
            }
            first = false;
            if (Arrays.equals(chunkid, ChunkHelper.IDAT)) {
                ignore = true;
            } else if (Arrays.equals(chunkid, ChunkHelper.IEND)) {
                endfound = true;
            }
            ChunkRaw chunk = new ChunkRaw(clen, chunkid, true);
            String chunkids = ChunkHelper.toString(chunkid);
            boolean loadchunk = ChunkHelper.shouldLoad(chunkids, this.chunkLoadBehaviour);
            this.foundChunksInfo.add(new FoundChunkInfo(chunkids, clen, this.offset - 8, loadchunk));
            this.offset += chunk.readChunkData(this.is);
            if (!loadchunk || ignore) continue;
            this.addChunkToList(chunk);
        }
        if (!endfound) {
            throw new PngjInputException("end chunk not found - offset=" + this.offset);
        }
    }

    public ImageLine readRow(int nrow) {
        this.readRow(this.imgLine.scanline, nrow);
        this.imgLine.incRown();
        return this.imgLine;
    }

    public int[] readRow(int[] buffer, int nrow) {
        if (nrow < 0 || nrow >= this.imgInfo.rows) {
            throw new PngjInputException("invalid line");
        }
        if (nrow != this.rowNum + 1) {
            throw new PngjInputException("invalid line (expected: " + (this.rowNum + 1));
        }
        ++this.rowNum;
        if (buffer == null || buffer.length < this.imgInfo.samplesPerRowP) {
            buffer = new int[this.imgInfo.samplesPerRowP];
        }
        int[] tmp = this.rowb;
        this.rowb = this.rowbprev;
        this.rowbprev = tmp;
        PngHelper.readBytes(this.idatIstream, this.rowbfilter, 0, this.rowbfilter.length);
        this.rowb[0] = this.rowbfilter[0];
        this.unfilterRow();
        this.convertRowFromBytes(buffer);
        return buffer;
    }

    private void convertRowFromBytes(int[] buffer) {
        if (this.imgInfo.bitDepth <= 8) {
            int i = 0;
            int j = 1;
            while (i < this.imgInfo.samplesPerRowP) {
                buffer[i] = this.rowb[j++];
                ++i;
            }
        } else {
            int i = 0;
            int j = 1;
            while (i < this.imgInfo.samplesPerRowP) {
                buffer[i] = (this.rowb[j++] << 8) + this.rowb[j++];
                ++i;
            }
        }
    }

    private void unfilterRow() {
        byte ftn = this.rowbfilter[0];
        PngFilterType ft = PngFilterType.getByVal(ftn);
        if (ft == null) {
            throw new PngjInputException("Filter type " + ftn + " invalid");
        }
        switch (ft) {
            case FILTER_NONE: {
                this.unfilterRowNone();
                break;
            }
            case FILTER_SUB: {
                this.unfilterRowSub();
                break;
            }
            case FILTER_UP: {
                this.unfilterRowUp();
                break;
            }
            case FILTER_AVERAGE: {
                this.unfilterRowAverage();
                break;
            }
            case FILTER_PAETH: {
                this.unfilterRowPaeth();
                break;
            }
            default: {
                throw new PngjInputException("Filter type " + ftn + " not implemented");
            }
        }
    }

    private void unfilterRowNone() {
        int i = 1;
        while (i <= this.imgInfo.bytesPerRow) {
            this.rowb[i] = this.rowbfilter[i] & 0xFF;
            ++i;
        }
    }

    private void unfilterRowSub() {
        int i = 1;
        while (i <= this.imgInfo.bytesPixel) {
            this.rowb[i] = this.rowbfilter[i] & 0xFF;
            ++i;
        }
        int j = 1;
        i = this.imgInfo.bytesPixel + 1;
        while (i <= this.imgInfo.bytesPerRow) {
            this.rowb[i] = (this.rowbfilter[i] & 0xFF) + this.rowb[j] & 0xFF;
            ++i;
            ++j;
        }
    }

    private void unfilterRowUp() {
        int i = 1;
        while (i <= this.imgInfo.bytesPerRow) {
            this.rowb[i] = (this.rowbfilter[i] & 0xFF) + this.rowbprev[i] & 0xFF;
            ++i;
        }
    }

    private void unfilterRowAverage() {
        int j = 1 - this.imgInfo.bytesPixel;
        int i = 1;
        while (i <= this.imgInfo.bytesPerRow) {
            int x = j > 0 ? this.rowb[j] : 0;
            this.rowb[i] = (this.rowbfilter[i] & 0xFF) + (x + this.rowbprev[i]) / 2 & 0xFF;
            ++i;
            ++j;
        }
    }

    private void unfilterRowPaeth() {
        int j = 1 - this.imgInfo.bytesPixel;
        int i = 1;
        while (i <= this.imgInfo.bytesPerRow) {
            int x = j > 0 ? this.rowb[j] : 0;
            int y = j > 0 ? this.rowbprev[j] : 0;
            this.rowb[i] = (this.rowbfilter[i] & 0xFF) + PngHelper.filterPaethPredictor(x, this.rowbprev[i], y) & 0xFF;
            ++i;
            ++j;
        }
    }

    public void end() {
        this.offset = (int)this.iIdatCstream.getOffset();
        try {
            this.idatIstream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.readLastChunks();
        try {
            this.is.close();
        }
        catch (Exception e) {
            throw new PngjInputException("error closing input stream!", e);
        }
    }

    public String toString() {
        return "filename=" + this.filename + " " + this.imgInfo.toString();
    }

    public void printFoundChunks() {
        for (FoundChunkInfo c : this.foundChunksInfo) {
            System.out.println(c);
        }
    }

    private static class FoundChunkInfo {
        public final String id;
        public final int len;
        public final int offset;
        public final boolean loaded;

        private FoundChunkInfo(String id, int len, int offset, boolean loaded) {
            this.id = id;
            this.len = len;
            this.offset = offset;
            this.loaded = loaded;
        }

        public String toString() {
            return "chunk " + this.id + " len=" + this.len + " offset=" + this.offset + (this.loaded ? " " : " X ");
        }
    }
}

