/*
 * Decompiled with CFR 0.152.
 */
package ar.com.hjg.pngj.chunks;

import ar.com.hjg.pngj.ImageInfo;
import ar.com.hjg.pngj.PngHelper;
import ar.com.hjg.pngj.PngjException;
import ar.com.hjg.pngj.chunks.ChunkRaw;
import ar.com.hjg.pngj.chunks.PngChunk;

public class PngChunkSBIT
extends PngChunk {
    private int graysb;
    private int alphasb;
    private int redsb;
    private int greensb;
    private int bluesb;

    public PngChunkSBIT(ImageInfo info) {
        super("sBIT", info);
    }

    private int getLen() {
        int len;
        int n = len = this.imgInfo.greyscale ? 1 : 3;
        if (this.imgInfo.alpha) {
            ++len;
        }
        return len;
    }

    public void parseFromChunk(ChunkRaw c) {
        if (c.len != this.getLen()) {
            throw new PngjException("bad chunk length " + c);
        }
        if (this.imgInfo.greyscale) {
            this.graysb = PngHelper.readInt1fromByte(c.data, 0);
            if (this.imgInfo.alpha) {
                this.alphasb = PngHelper.readInt1fromByte(c.data, 1);
            }
        } else {
            this.redsb = PngHelper.readInt1fromByte(c.data, 0);
            this.greensb = PngHelper.readInt1fromByte(c.data, 1);
            this.bluesb = PngHelper.readInt1fromByte(c.data, 2);
            if (this.imgInfo.alpha) {
                this.alphasb = PngHelper.readInt1fromByte(c.data, 3);
            }
        }
    }

    public ChunkRaw createChunk() {
        ChunkRaw c = null;
        c = this.createEmptyChunk(this.getLen(), true);
        if (this.imgInfo.greyscale) {
            c.data[0] = (byte)this.graysb;
            if (this.imgInfo.alpha) {
                c.data[1] = (byte)this.alphasb;
            }
        } else {
            c.data[0] = (byte)this.redsb;
            c.data[1] = (byte)this.greensb;
            c.data[2] = (byte)this.bluesb;
            if (this.imgInfo.alpha) {
                c.data[3] = (byte)this.alphasb;
            }
        }
        return c;
    }

    public void cloneDataFromRead(PngChunk other) {
        PngChunkSBIT otherx = (PngChunkSBIT)other;
        this.graysb = otherx.graysb;
        this.redsb = otherx.redsb;
        this.greensb = otherx.greensb;
        this.bluesb = otherx.bluesb;
        this.alphasb = otherx.alphasb;
    }
}

