/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.cifex.rpc.client.cli;

import ch.systemsx.cisd.args4j.Option;
import ch.systemsx.cisd.cifex.rpc.client.cli.AbstractCommand;
import ch.systemsx.cisd.cifex.rpc.client.cli.MinimalParameters;
import ch.systemsx.cisd.cifex.rpc.client.encryption.OpenPGPSymmetricKeyEncryption;
import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import java.io.File;
import org.apache.commons.lang.StringUtils;

public class EncryptCommand
extends AbstractCommand {
    private static final String NAME = "encrypt";
    private static EncryptCommand instance;

    public static final synchronized EncryptCommand getInstance() {
        if (instance == null) {
            instance = new EncryptCommand();
        }
        return instance;
    }

    private EncryptCommand() {
        super(NAME);
    }

    private String getPassphraseOrExit(Parameters parameters) {
        String passphraseRepeat;
        if (parameters.isShortPassphrase()) {
            String passphrase = EncryptCommand.generatePassphrase(true);
            System.out.println("Password is: " + passphrase);
            return passphrase;
        }
        if (parameters.isGeneratePassphrase()) {
            String passphrase = EncryptCommand.generatePassphrase(false);
            System.out.println("Passphrase is: " + passphrase);
            return passphrase;
        }
        String passphrase = this.tryGetPassphrase("Passphrase: ", parameters.getPassphrase());
        if (StringUtils.isBlank((String)passphrase)) {
            System.err.println("No passphrase has been specified, exiting.");
            System.exit(1);
        }
        if (!passphrase.equals(passphraseRepeat = this.tryGetPassphrase("Passphrase (repeat): ", parameters.getPassphrase()))) {
            System.err.println("The two passphrases do not match, exiting.");
            System.exit(1);
        }
        return passphrase;
    }

    @Override
    public int execute(String[] arguments) throws UserFailureException, EnvironmentFailureException {
        Parameters parameters = new Parameters(arguments);
        String passphrase = this.getPassphraseOrExit(parameters);
        OpenPGPSymmetricKeyEncryption.encrypt(parameters.getInFile(), parameters.getOutFile(), passphrase, parameters.isOverwriteOutputFile());
        return 0;
    }

    private static class Parameters
    extends MinimalParameters {
        private File inFile;
        private File outFile;
        @Option(name="p", longName="passphrase", metaVar="STRING", usage="The pass phrase to use for encryption.")
        private String passphrase;
        @Option(name="g", longName="generate-passphrase", metaVar="FLAG", usage="Automatically generate a passphrase (incompatible with -p).", skipForExample=true)
        private boolean generatePassphrase;
        @Option(name="s", longName="short-passphrase", metaVar="FLAG", usage="Create a short and quite memorizable password (implies -g).", skipForExample=true)
        private boolean shortPassphrase;
        @Option(name="O", longName="overwrote-output-file", metaVar="FLAG", usage="Whether an already existing output file should be silently overwritten.")
        private boolean overwriteOutputFile;

        public Parameters(String[] args) {
            super(args, EncryptCommand.NAME, "<file>");
            if (this.getArgs().size() != 1 || this.getPassphrase() != null && this.isGeneratePassphrase()) {
                this.printHelp(true);
            }
            this.inFile = new File(this.getArgs().get(0));
            this.outFile = new File(String.valueOf(this.getArgs().get(0)) + ".pgp");
        }

        public File getInFile() {
            return this.inFile;
        }

        public File getOutFile() {
            return this.outFile;
        }

        public boolean isOverwriteOutputFile() {
            return this.overwriteOutputFile;
        }

        public String getPassphrase() {
            return this.passphrase;
        }

        public boolean isGeneratePassphrase() {
            return this.generatePassphrase || this.shortPassphrase;
        }

        public boolean isShortPassphrase() {
            return this.shortPassphrase;
        }
    }
}

