/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp.managed;

import java.sql.SQLException;
import java.util.Collection;
import javax.sql.XADataSource;
import javax.transaction.TransactionManager;
import org.apache.commons.dbcp.AbandonedConfig;
import org.apache.commons.dbcp.BasicDataSource;
import org.apache.commons.dbcp.ConnectionFactory;
import org.apache.commons.dbcp.managed.DataSourceXAConnectionFactory;
import org.apache.commons.dbcp.managed.LocalXAConnectionFactory;
import org.apache.commons.dbcp.managed.ManagedDataSource;
import org.apache.commons.dbcp.managed.PoolableManagedConnectionFactory;
import org.apache.commons.dbcp.managed.TransactionRegistry;
import org.apache.commons.dbcp.managed.XAConnectionFactory;
import org.apache.commons.pool.KeyedObjectPoolFactory;
import org.apache.commons.pool.ObjectPool;

public class BasicManagedDataSource
extends BasicDataSource {
    private TransactionRegistry transactionRegistry;
    private transient TransactionManager transactionManager;
    private String xaDataSource;
    private XADataSource xaDataSourceInstance;

    public synchronized XADataSource getXaDataSourceInstance() {
        return this.xaDataSourceInstance;
    }

    public synchronized void setXaDataSourceInstance(XADataSource xADataSource) {
        this.xaDataSourceInstance = xADataSource;
        this.xaDataSource = xADataSource == null ? null : xADataSource.getClass().getName();
    }

    public TransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    protected synchronized TransactionRegistry getTransactionRegistry() {
        return this.transactionRegistry;
    }

    public void setTransactionManager(TransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public synchronized String getXADataSource() {
        return this.xaDataSource;
    }

    public synchronized void setXADataSource(String string) {
        this.xaDataSource = string;
    }

    protected ConnectionFactory createConnectionFactory() throws SQLException {
        Object object;
        if (this.transactionManager == null) {
            throw new SQLException("Transaction manager must be set before a connection can be created");
        }
        if (this.xaDataSource == null) {
            ConnectionFactory connectionFactory = super.createConnectionFactory();
            LocalXAConnectionFactory localXAConnectionFactory = new LocalXAConnectionFactory(this.getTransactionManager(), connectionFactory);
            this.transactionRegistry = localXAConnectionFactory.getTransactionRegistry();
            return localXAConnectionFactory;
        }
        if (this.xaDataSourceInstance == null) {
            object = null;
            try {
                object = Class.forName(this.xaDataSource);
            }
            catch (Throwable throwable) {
                String string = "Cannot load XA data source class '" + this.xaDataSource + "'";
                throw (SQLException)new SQLException(string).initCause(throwable);
            }
            try {
                this.xaDataSourceInstance = (XADataSource)((Class)object).newInstance();
            }
            catch (Throwable throwable) {
                String string = "Cannot create XA data source of class '" + this.xaDataSource + "'";
                throw (SQLException)new SQLException(string).initCause(throwable);
            }
        }
        object = new DataSourceXAConnectionFactory(this.getTransactionManager(), this.xaDataSourceInstance, this.username, this.password);
        this.transactionRegistry = object.getTransactionRegistry();
        return object;
    }

    protected void createDataSourceInstance() throws SQLException {
        ManagedDataSource managedDataSource = new ManagedDataSource((ObjectPool)this.connectionPool, this.transactionRegistry);
        managedDataSource.setAccessToUnderlyingConnectionAllowed(this.isAccessToUnderlyingConnectionAllowed());
        managedDataSource.setLogWriter(this.logWriter);
        this.dataSource = managedDataSource;
    }

    protected void createPoolableConnectionFactory(ConnectionFactory connectionFactory, KeyedObjectPoolFactory keyedObjectPoolFactory, AbandonedConfig abandonedConfig) throws SQLException {
        PoolableManagedConnectionFactory poolableManagedConnectionFactory = null;
        try {
            poolableManagedConnectionFactory = new PoolableManagedConnectionFactory((XAConnectionFactory)connectionFactory, (ObjectPool)this.connectionPool, keyedObjectPoolFactory, this.validationQuery, this.validationQueryTimeout, (Collection)this.connectionInitSqls, this.defaultReadOnly, this.defaultAutoCommit, this.defaultTransactionIsolation, this.defaultCatalog, abandonedConfig);
            BasicManagedDataSource.validateConnectionFactory(poolableManagedConnectionFactory);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw (SQLException)new SQLException("Cannot create PoolableConnectionFactory (" + exception.getMessage() + ")").initCause(exception);
        }
    }
}

