/*
 * Decompiled with CFR 0.152.
 */
package net.lemnik.eodsql;

import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import javax.sql.DataSource;
import net.lemnik.eodsql.BaseQuery;
import net.lemnik.eodsql.DataSet;
import net.lemnik.eodsql.InvalidDataTypeException;
import net.lemnik.eodsql.InvalidQueryException;
import net.lemnik.eodsql.QueryFactoryChain;
import net.lemnik.eodsql.QuickQueryUtil;
import net.lemnik.eodsql.TypeMapper;
import net.lemnik.eodsql.impl.ExceptionTranslationUtils;
import net.lemnik.eodsql.impl.ManagedConnections;
import net.lemnik.eodsql.spi.MethodImplementationFactory;
import net.lemnik.eodsql.spi.QueryFactory;
import net.lemnik.eodsql.spi.util.DataObjectBinding;
import net.lemnik.eodsql.spi.util.MapDataObjectBinding;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryTool {
    private static DataSource defaultDataSource = null;
    private static final Map<Class, TypeMapper> typeMap = new HashMap<Class, TypeMapper>();
    private static final Map<Class<? extends Annotation>, MethodImplementationFactory<?>> methodFactories = Collections.synchronizedMap(new IdentityHashMap());
    private static final QueryFactoryChain factoryChain = new QueryFactoryChain();

    private QueryTool() {
    }

    private static Class<? extends Annotation> getMethodFactoryAnnotation(MethodImplementationFactory<? extends Annotation> methodImplementationFactory) {
        Type[] typeArray;
        Class<?> clazz = methodImplementationFactory.getClass();
        for (Type type : typeArray = clazz.getGenericInterfaces()) {
            ParameterizedType parameterizedType;
            if (!(type instanceof ParameterizedType) || (parameterizedType = (ParameterizedType)type).getRawType() != MethodImplementationFactory.class) continue;
            Type[] typeArray2 = parameterizedType.getActualTypeArguments();
            if (typeArray2.length == 0 || !(typeArray2[0] instanceof Class)) break;
            return (Class)typeArray2[0];
        }
        return null;
    }

    public static void setDefaultDataSource(DataSource dataSource) {
        if (dataSource == null) {
            throw new IllegalArgumentException("the default data source may not be set to null.");
        }
        defaultDataSource = dataSource;
    }

    public static DataSource getDefaultDataSource() {
        return defaultDataSource;
    }

    public static <T extends BaseQuery> T getQuery(Class<T> clazz) throws InvalidDataTypeException, InvalidQueryException {
        if (defaultDataSource != null) {
            return QueryTool.getQuery(defaultDataSource, clazz);
        }
        throw new IllegalStateException("the default DataSource has not been set.");
    }

    public static <T extends BaseQuery> T getQuery(DataSource dataSource, Class<T> clazz) throws InvalidDataTypeException, InvalidQueryException {
        if (dataSource != null) {
            return QueryTool.getQuery(dataSource, clazz, Thread.currentThread().getContextClassLoader());
        }
        throw new IllegalArgumentException("dataSource cannot be null");
    }

    public static <T extends BaseQuery> T getQuery(DataSource dataSource, Class<T> clazz, ClassLoader classLoader) throws InvalidDataTypeException, InvalidQueryException {
        if (dataSource != null) {
            return factoryChain.create(dataSource, clazz, classLoader);
        }
        throw new IllegalArgumentException("dataSource cannot be null");
    }

    public static <T extends BaseQuery> T getQuery(Connection connection, Class<T> clazz) throws InvalidDataTypeException, InvalidQueryException {
        return QueryTool.getQuery(connection, clazz, Thread.currentThread().getContextClassLoader());
    }

    public static <T extends BaseQuery> T getQuery(Connection connection, Class<T> clazz, ClassLoader classLoader) throws InvalidDataTypeException, InvalidQueryException {
        return factoryChain.create(connection, clazz, classLoader);
    }

    public static <T extends BaseQuery> T getManagedQuery(String string, Class<T> clazz, ClassLoader classLoader) throws InvalidDataTypeException, InvalidQueryException {
        return factoryChain.create(string, clazz, classLoader);
    }

    public static <T extends BaseQuery> T getManagedQuery(String string, Class<T> clazz) throws InvalidDataTypeException, InvalidQueryException {
        return factoryChain.create(string, clazz, Thread.currentThread().getContextClassLoader());
    }

    public static <T extends BaseQuery> T getManagedQuery(Class<T> clazz, ClassLoader classLoader) throws InvalidDataTypeException, InvalidQueryException {
        return factoryChain.create("DEFAULT", clazz, classLoader);
    }

    public static <T extends BaseQuery> T getManagedQuery(Class<T> clazz) throws InvalidDataTypeException, InvalidQueryException {
        return factoryChain.create("DEFAULT", clazz, Thread.currentThread().getContextClassLoader());
    }

    public static <T> DataSet<T> select(Class<T> clazz, String string, Object ... objectArray) throws InvalidDataTypeException, InvalidQueryException {
        if (defaultDataSource != null) {
            return QueryTool.select(defaultDataSource, clazz, string, objectArray);
        }
        throw new IllegalStateException("the default DataSource has not been set.");
    }

    public static <T> DataSet<T> selectManaged(Class<T> clazz, String string, Object ... objectArray) throws InvalidDataTypeException, InvalidQueryException {
        return QueryTool.selectManaged("DEFAULT", clazz, string, objectArray);
    }

    public static <T> DataSet<T> selectManaged(String string, Class<T> clazz, String string2, Object ... objectArray) throws InvalidDataTypeException, InvalidQueryException {
        if (string == null) {
            throw new IllegalArgumentException("The name of a database must be specified for QueryTool.selectManaged");
        }
        if (clazz == null) {
            throw new IllegalArgumentException("The DataObject type must be non-null for QueryTool.selectManaged");
        }
        if (string2 == null || string2.length() == 0) {
            throw new IllegalArgumentException("You must specify a query for QueryTool.selectManaged");
        }
        DataObjectBinding.validate(clazz);
        Connection connection = ManagedConnections.checkAndGetConnection(string);
        try {
            return QuickQueryUtil.selectDataSet(connection, true, clazz, string2, objectArray);
        }
        catch (SQLException sQLException) {
            if (ExceptionTranslationUtils.isDefaultTranslator()) {
                throw new InvalidQueryException("Couldn't execute query: '" + string2 + "'", sQLException);
            }
            throw ExceptionTranslationUtils.translateException(connection, "QueryTool.selectManaged()", string2, (Exception)sQLException);
        }
        catch (ParseException parseException) {
            throw new InvalidQueryException("Cannot parser EoD SQL query: '" + string2 + "'", parseException);
        }
    }

    public static <T> DataSet<T> select(DataSource dataSource, Class<T> clazz, String string, Object ... objectArray) throws InvalidDataTypeException, InvalidQueryException {
        if (dataSource == null) {
            throw new IllegalArgumentException("A DataSource must be specified for QueryTool.select");
        }
        if (clazz == null) {
            throw new IllegalArgumentException("The DataObject type must be non-null for QueryTool.select");
        }
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("You must specify a query for QueryTool.select");
        }
        DataObjectBinding.validate(clazz);
        try {
            return QuickQueryUtil.selectDataSet(dataSource.getConnection(), true, clazz, string, objectArray);
        }
        catch (SQLException sQLException) {
            if (ExceptionTranslationUtils.isDefaultTranslator()) {
                throw new InvalidQueryException("Couldn't execute query: '" + string + "'", sQLException);
            }
            throw ExceptionTranslationUtils.translateException(dataSource, "QueryTool.select()", string, (Exception)sQLException);
        }
        catch (ParseException parseException) {
            throw new InvalidQueryException("Cannot parser EoD SQL query: '" + string + "'", parseException);
        }
    }

    public static <T> DataSet<T> select(Connection connection, Class<T> clazz, String string, Object ... objectArray) throws InvalidDataTypeException, InvalidQueryException {
        if (connection == null) {
            throw new IllegalArgumentException("A Connection must be specified for QueryTool.select");
        }
        if (clazz == null) {
            throw new IllegalArgumentException("The DataObject type must be non-null for QueryTool.select");
        }
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("You must specify a query for QueryTool.select");
        }
        DataObjectBinding.validate(clazz);
        try {
            return QuickQueryUtil.selectDataSet(connection, false, clazz, string, objectArray);
        }
        catch (SQLException sQLException) {
            if (ExceptionTranslationUtils.isDefaultTranslator()) {
                throw new InvalidQueryException("Couldn't execute query: '" + string + "'", sQLException);
            }
            throw ExceptionTranslationUtils.translateException(connection, "QueryTool.select()", string, (Exception)sQLException);
        }
        catch (ParseException parseException) {
            throw new InvalidQueryException("Cannot parser EoD SQL query: '" + string + "'", parseException);
        }
    }

    public static DataSet<Map<String, Object>> select(String string, Object ... objectArray) throws InvalidDataTypeException, InvalidQueryException {
        if (defaultDataSource != null) {
            return QueryTool.select(defaultDataSource, MapDataObjectBinding.getStringObjectMapObjectType(), string, objectArray);
        }
        throw new IllegalStateException("the default DataSource has not been set.");
    }

    public static DataSet<Map<String, Object>> select(DataSource dataSource, String string, Object ... objectArray) throws InvalidDataTypeException, InvalidQueryException {
        return QueryTool.select(dataSource, MapDataObjectBinding.getStringObjectMapObjectType(), string, objectArray);
    }

    public static DataSet<Map<String, Object>> select(Connection connection, String string, Object ... objectArray) throws InvalidDataTypeException, InvalidQueryException {
        return QueryTool.select(connection, MapDataObjectBinding.getStringObjectMapObjectType(), string, objectArray);
    }

    public static int update(Connection connection, String string, Object ... objectArray) throws InvalidDataTypeException, InvalidQueryException {
        if (connection == null) {
            throw new IllegalArgumentException("A Connection must be specified for update");
        }
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("You must specify a query for update");
        }
        try {
            return QuickQueryUtil.update(connection, false, string, objectArray);
        }
        catch (SQLException sQLException) {
            if (ExceptionTranslationUtils.isDefaultTranslator()) {
                throw new InvalidQueryException("Couldn't execute query: '" + string + "'", sQLException);
            }
            throw ExceptionTranslationUtils.translateException(connection, "QueryTool.update()", string, (Exception)sQLException);
        }
        catch (ParseException parseException) {
            throw new InvalidQueryException("Cannot parser EoD SQL query: '" + string + "'", parseException);
        }
    }

    public static int updateManaged(String string, Object ... objectArray) throws InvalidDataTypeException, InvalidQueryException {
        return QueryTool.updateManaged("DEFAULT", string, objectArray);
    }

    public static int updateManaged(String string, String string2, Object ... objectArray) throws InvalidDataTypeException, InvalidQueryException {
        if (string == null) {
            throw new IllegalArgumentException("The name of a database must be specified for updateManaged");
        }
        if (string2 == null || string2.length() == 0) {
            throw new IllegalArgumentException("You must specify a query for updateManaged");
        }
        Connection connection = ManagedConnections.checkAndGetConnection(string);
        try {
            return QuickQueryUtil.update(connection, false, string2, objectArray);
        }
        catch (SQLException sQLException) {
            if (ExceptionTranslationUtils.isDefaultTranslator()) {
                throw new InvalidQueryException("Couldn't execute query: '" + string2 + "'", sQLException);
            }
            throw ExceptionTranslationUtils.translateException(connection, "QueryTool.updateManaged()", string2, (Exception)sQLException);
        }
        catch (ParseException parseException) {
            throw new InvalidQueryException("Cannot parser EoD SQL query: '" + string2 + "'", parseException);
        }
    }

    public static int update(DataSource dataSource, String string, Object ... objectArray) throws InvalidDataTypeException, InvalidQueryException {
        if (dataSource == null) {
            throw new IllegalArgumentException("A DataSource must be specified for update");
        }
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("You must specify a query for update");
        }
        try {
            return QuickQueryUtil.update(dataSource.getConnection(), true, string, objectArray);
        }
        catch (SQLException sQLException) {
            if (ExceptionTranslationUtils.isDefaultTranslator()) {
                throw new InvalidQueryException("Couldn't execute query: '" + string + "'", sQLException);
            }
            throw ExceptionTranslationUtils.translateException(dataSource, "QueryTool.select()", string, (Exception)sQLException);
        }
        catch (ParseException parseException) {
            throw new InvalidQueryException("Cannot parser EoD SQL query: '" + string + "'", parseException);
        }
    }

    public static int update(String string, Object ... objectArray) throws InvalidDataTypeException, InvalidQueryException {
        if (defaultDataSource != null) {
            return QueryTool.update(defaultDataSource, string, objectArray);
        }
        throw new IllegalStateException("the default DataSource has not been set.");
    }

    public static Map<Class, TypeMapper> getTypeMap() {
        return typeMap;
    }

    public static void addQueryFactory(QueryFactory queryFactory) throws IllegalArgumentException {
        if (queryFactory == null) {
            throw new IllegalArgumentException("QueryFactory may not be null!");
        }
        factoryChain.add(queryFactory);
    }

    public static void removeQueryFactory(QueryFactory queryFactory) {
        if (queryFactory != null) {
            factoryChain.remove(queryFactory);
        }
    }

    public static void addMethodImplementationFactory(MethodImplementationFactory<? extends Annotation> methodImplementationFactory) throws IllegalArgumentException {
        if (methodImplementationFactory == null) {
            throw new IllegalArgumentException("MethodImplementationFactory may not be null");
        }
        Class<? extends Annotation> clazz = QueryTool.getMethodFactoryAnnotation(methodImplementationFactory);
        if (clazz == null) {
            throw new IllegalArgumentException("A MethodImplementationFactory must directly implement MethodImplementationFactory and have the final Annotation type in it's generic declaration.");
        }
        methodFactories.put(clazz, methodImplementationFactory);
    }

    public static <T extends Annotation> MethodImplementationFactory<T> getMethodImplementationFactory(Class<T> clazz) {
        MethodImplementationFactory<?> methodImplementationFactory = methodFactories.get(clazz);
        return methodImplementationFactory;
    }

    public static void setManagedDatabaseConnection(String string, Connection connection) {
        ManagedConnections.setConnection(string, connection);
    }

    public static void setManagedDatabaseConnection(Connection connection) {
        ManagedConnections.setConnection("DEFAULT", connection);
    }

    public static void clearManagedDatabaseConnection(String string) {
        ManagedConnections.clearConnection(string);
    }

    public static void clearManagedDatabaseConnection() {
        ManagedConnections.clearConnection("DEFAULT");
    }
}

