/*
 * Decompiled with CFR 0.152.
 */
package net.lemnik.eodsql.impl;

import java.sql.Connection;
import java.util.HashMap;
import java.util.Map;

public class ManagedConnections {
    public static final String DEFAULT_DATABASE = "DEFAULT";
    private static final Map<String, ThreadLocal<Connection>> connections = new HashMap<String, ThreadLocal<Connection>>();

    public static synchronized void setConnection(String string, Connection connection) {
        ThreadLocal<Connection> threadLocal = connections.get(string);
        if (threadLocal == null) {
            threadLocal = new ThreadLocal();
            connections.put(string, threadLocal);
        }
        threadLocal.set(connection);
    }

    public static void clearConnection(String string) {
        ManagedConnections.setConnection(string, null);
    }

    public static synchronized Connection getConnection(String string) {
        ThreadLocal<Connection> threadLocal = connections.get(string);
        return threadLocal != null ? threadLocal.get() : null;
    }

    public static synchronized Connection checkAndGetConnection(String string) throws IllegalStateException {
        Connection connection;
        ThreadLocal<Connection> threadLocal = connections.get(string);
        Connection connection2 = connection = threadLocal != null ? threadLocal.get() : null;
        if (connection == null) {
            throw new IllegalStateException("No database connection for database " + string);
        }
        return connection;
    }
}

