/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.imagereaders.jai;

import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.base.exceptions.IOExceptionUnchecked;
import ch.systemsx.cisd.base.io.AdapterIInputStreamToInputStream;
import ch.systemsx.cisd.base.io.IInputStream;
import ch.systemsx.cisd.base.io.IRandomAccessFile;
import ch.systemsx.cisd.imagereaders.IReadParams;
import ch.systemsx.cisd.imagereaders.ImageID;
import ch.systemsx.cisd.imagereaders.jai.DefaultImageReader;
import com.sun.media.jai.codec.ImageCodec;
import com.sun.media.jai.codec.ImageDecoder;
import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import java.io.IOException;
import java.io.InputStream;

class TiffImageReader
extends DefaultImageReader {
    public TiffImageReader(String libraryName, String readerName) {
        super(libraryName, readerName);
    }

    @Override
    public BufferedImage readImage(IRandomAccessFile handle, ImageID imageID, IReadParams params) throws IOExceptionUnchecked {
        try {
            AdapterIInputStreamToInputStream input = new AdapterIInputStreamToInputStream((IInputStream)handle);
            ImageDecoder decoder = ImageCodec.createImageDecoder((String)this.getName(), (InputStream)input, null);
            Raster raster = decoder.decodeAsRaster(imageID.getTimeSeriesIndex());
            int bufferType = this.findBestImageBufferType(raster);
            BufferedImage image = new BufferedImage(raster.getWidth(), raster.getHeight(), bufferType);
            image.setData(raster);
            return image;
        }
        catch (IOException ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary((Exception)ex);
        }
    }

    private int findBestImageBufferType(Raster raster) {
        boolean isGrayscale = raster.getNumBands() == 1;
        int numberOfBits = raster.getSampleModel().getSampleSize()[0];
        if (isGrayscale) {
            if (numberOfBits <= 8) {
                return 10;
            }
            return 11;
        }
        return 1;
    }
}

