/*
 * Decompiled with CFR 0.152.
 */
package ome.xml.model;

import java.io.StringReader;
import java.io.StringWriter;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import ome.xml.model.OMEModel;
import ome.xml.model.OMEModelObject;
import ome.xml.model.Reference;
import ome.xml.model.StructuredAnnotations;
import ome.xml.model.TextAnnotation;
import ome.xml.model.enums.EnumerationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class XMLAnnotation
extends TextAnnotation {
    public static final String NAMESPACE = "http://www.openmicroscopy.org/Schemas/SA/2012-06";
    private static final Logger LOGGER = LoggerFactory.getLogger(XMLAnnotation.class);
    private String value;
    private StructuredAnnotations structuredAnnotations;

    public XMLAnnotation() {
    }

    public XMLAnnotation(Element element, OMEModel model) throws EnumerationException {
        this.update(element, model);
    }

    public void update(Element element, OMEModel model) throws EnumerationException {
        List<Element> Value_nodeList;
        super.update(element, model);
        String tagName = element.getTagName();
        if (!"XMLAnnotation".equals(tagName)) {
            LOGGER.debug("Expecting node name of XMLAnnotation got {}", (Object)tagName);
        }
        if ((Value_nodeList = XMLAnnotation.getChildrenByTagName(element, "Value")).size() > 1) {
            throw new RuntimeException(String.format("Value node list size %d != 1", Value_nodeList.size()));
        }
        if (Value_nodeList.size() != 0) {
            StringWriter sw = new StringWriter();
            StreamResult sr = new StreamResult(sw);
            TransformerFactory tf = TransformerFactory.newInstance();
            try {
                Transformer t = tf.newTransformer(new StreamSource(this.getClass().getResourceAsStream("StripWhitespace.xsl")));
                t.setOutputProperty("omit-xml-declaration", "yes");
                t.setOutputProperty("indent", "no");
                NodeList childNodeList = Value_nodeList.get(0).getChildNodes();
                for (int i = 0; i < childNodeList.getLength(); ++i) {
                    try {
                        t.transform(new DOMSource(childNodeList.item(i)), sr);
                        continue;
                    }
                    catch (TransformerException te) {
                        LOGGER.warn("Failed to transform node #" + i, te);
                    }
                }
                this.setValue(sw.toString().trim());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public boolean link(Reference reference, OMEModelObject o) {
        boolean wasHandledBySuperClass = super.link(reference, o);
        if (wasHandledBySuperClass) {
            return true;
        }
        LOGGER.debug("Unable to handle reference of type: {}", reference.getClass());
        return false;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public StructuredAnnotations getStructuredAnnotations() {
        return this.structuredAnnotations;
    }

    public void setStructuredAnnotations(StructuredAnnotations structuredAnnotations_BackReference) {
        this.structuredAnnotations = structuredAnnotations_BackReference;
    }

    public Element asXMLElement(Document document) {
        return this.asXMLElement(document, null);
    }

    protected Element asXMLElement(Document document, Element XMLAnnotation_element) {
        if (XMLAnnotation_element == null) {
            XMLAnnotation_element = document.createElementNS(NAMESPACE, "XMLAnnotation");
        }
        if (this.value != null) {
            Document Value_document = null;
            try {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                factory.setNamespaceAware(true);
                DocumentBuilder parser = factory.newDocumentBuilder();
                InputSource is = new InputSource();
                is.setCharacterStream(new StringReader(this.value));
                Value_document = parser.parse(is);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            Element value_element = document.createElementNS(NAMESPACE, "Value");
            NodeList Value_subNodes = Value_document.getChildNodes();
            for (int i = 0; i < Value_subNodes.getLength(); ++i) {
                Node Value_subNode = Value_subNodes.item(i);
                Value_subNode = document.importNode(Value_subNode, true);
                value_element.appendChild(Value_subNode);
            }
            XMLAnnotation_element.appendChild(value_element);
        }
        if (this.structuredAnnotations != null) {
            // empty if block
        }
        return super.asXMLElement(document, XMLAnnotation_element);
    }
}

