/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dataset.transform;

import ucar.nc2.Variable;
import ucar.nc2.dataset.CoordinateTransform;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.ProjectionCT;
import ucar.nc2.dataset.TransformType;
import ucar.nc2.dataset.transform.AbstractCoordTransBuilder;

public class Stereographic
extends AbstractCoordTransBuilder {
    public String getTransformName() {
        return "stereographic";
    }

    public TransformType getTransformType() {
        return TransformType.Projection;
    }

    public CoordinateTransform makeCoordinateTransform(NetcdfDataset ds, Variable ctv) {
        double lat0;
        double lon0 = this.readAttributeDouble(ctv, "longitude_of_projection_origin");
        double scale = this.readAttributeDouble(ctv, "scale_factor_at_projection_origin");
        if (Double.isNaN(scale)) {
            scale = 1.0;
        }
        if (Double.isNaN(lat0 = this.readAttributeDouble(ctv, "latitude_of_projection_origin"))) {
            lat0 = 90.0;
        }
        ucar.unidata.geoloc.projection.Stereographic proj = new ucar.unidata.geoloc.projection.Stereographic(lat0, lon0, scale);
        return new ProjectionCT(ctv.getShortName(), "FGDC", proj);
    }
}

