/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ncml;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.util.DateFromString;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.IndexIterator;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.MAMath;
import ucar.ma2.Range;
import ucar.ma2.Section;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.NetcdfFileCache;
import ucar.nc2.NetcdfFileFactory;
import ucar.nc2.ProxyReader;
import ucar.nc2.Variable;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.NetcdfDatasetCache;
import ucar.nc2.dataset.NetcdfDatasetFactory;
import ucar.nc2.dataset.ReplaceVariableCheck;
import ucar.nc2.dataset.VariableDS;
import ucar.nc2.dataset.VariableEnhanced;
import ucar.nc2.ncml.AggregationIF;
import ucar.nc2.units.DateFormatter;
import ucar.nc2.units.TimeUnit;
import ucar.nc2.util.CancelTask;
import ucar.nc2.util.DiskCache2;
import ucar.unidata.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Aggregation
implements AggregationIF,
ProxyReader {
    protected static int TYPICAL_DATASET_RANDOM = 0;
    protected static int TYPICAL_DATASET_LATEST = 1;
    protected static int TYPICAL_DATASET_PENULTIMATE = 2;
    protected static int typicalDatasetMode = 0;
    protected static Logger logger = LoggerFactory.getLogger(Aggregation.class);
    protected static DiskCache2 diskCache2 = null;
    protected NetcdfDataset ncDataset;
    protected String dimName;
    protected AggregationIF.Type type;
    protected List<Dataset> nestedDatasets;
    private int totalCoords = 0;
    protected Object spiObject;
    private List<String> vars = new ArrayList<String>();
    protected List<Dataset> explicitDatasets = new ArrayList<Dataset>();
    protected List<DirectoryScan> scanList = new ArrayList<DirectoryScan>();
    protected TimeUnit recheck;
    protected long lastChecked;
    protected boolean wasChanged = true;
    protected boolean isDate = false;
    protected DateFormatter formatter = new DateFormatter();
    protected boolean debug = false;
    protected boolean debugOpenFile = false;
    protected boolean debugCacheDetail = false;
    protected boolean debugSyncDetail = false;
    protected boolean debugProxy = false;
    protected boolean debugScan = false;
    protected boolean debugRead = false;

    public static void setPersistenceCache(DiskCache2 dc) {
        diskCache2 = dc;
    }

    public static void setTypicalDatasetMode(String mode) {
        if (mode.equalsIgnoreCase("random")) {
            typicalDatasetMode = TYPICAL_DATASET_RANDOM;
        } else if (mode.equalsIgnoreCase("latest")) {
            typicalDatasetMode = TYPICAL_DATASET_LATEST;
        } else if (mode.equalsIgnoreCase("penultimate")) {
            typicalDatasetMode = TYPICAL_DATASET_PENULTIMATE;
        } else {
            logger.error("Unknown setTypicalDatasetMode= " + mode);
        }
    }

    protected Aggregation(NetcdfDataset ncd, String dimName, AggregationIF.Type type, String recheckS) {
        this.ncDataset = ncd;
        this.dimName = dimName;
        this.type = type;
        if (recheckS != null) {
            try {
                this.recheck = new TimeUnit(recheckS);
            }
            catch (Exception e) {
                logger.error("Invalid time unit for recheckEvery = {}", (Object)recheckS);
            }
        }
    }

    public void addExplicitDataset(String cacheName, String location, String ncoordS, String coordValueS, NetcdfFileFactory reader, CancelTask cancelTask) {
        Dataset nested = this.makeDataset(cacheName, location, ncoordS, coordValueS, false, reader);
        this.explicitDatasets.add(nested);
    }

    public void addDataset(Dataset nested) {
        this.explicitDatasets.add(nested);
    }

    public void addDirectoryScan(String dirName, String suffix, String regexpPatternString, String dateFormatMark, String enhance, String subdirs, String olderThan) throws IOException {
        DirectoryScan d = new DirectoryScan(dirName, suffix, regexpPatternString, dateFormatMark, enhance, subdirs, olderThan);
        this.scanList.add(d);
        if (dateFormatMark != null) {
            this.isDate = true;
        }
    }

    public void addVariable(String varName) {
        this.vars.add(varName);
    }

    @Override
    public String getDimensionName() {
        return this.dimName;
    }

    public int getTotalCoords() {
        return this.totalCoords;
    }

    public List<Dataset> getNestedDatasets() {
        return this.nestedDatasets;
    }

    public AggregationIF.Type getType() {
        return this.type;
    }

    public boolean isDate() {
        return this.isDate;
    }

    public List<String> getVariables() {
        return this.vars;
    }

    public DataType getCoordinateType() {
        Dataset first = this.nestedDatasets.get(0);
        return first.isStringValued ? DataType.STRING : DataType.DOUBLE;
    }

    @Override
    public void close() throws IOException {
        this.persist();
        for (Dataset ds : this.nestedDatasets) {
            ds.close();
        }
    }

    @Override
    public void persist() throws IOException {
    }

    protected void persistRead() {
    }

    private boolean isAggVariable(String name) {
        for (String vname : this.vars) {
            if (!vname.equals(name)) continue;
            return true;
        }
        return false;
    }

    public void finish(CancelTask cancelTask) throws IOException {
        this.nestedDatasets = new ArrayList<Dataset>();
        for (Dataset dataset : this.explicitDatasets) {
            if (!dataset.checkOK(cancelTask)) continue;
            this.nestedDatasets.add(dataset);
        }
        if (this.scanList.size() > 0) {
            this.scan(this.nestedDatasets, cancelTask);
        }
        if (diskCache2 != null && this.type == AggregationIF.Type.JOIN_EXISTING) {
            this.persistRead();
        }
        this.buildDataset(true, cancelTask);
        this.lastChecked = System.currentTimeMillis();
        this.wasChanged = true;
    }

    protected abstract void buildDataset(boolean var1, CancelTask var2) throws IOException;

    protected void buildCoords(CancelTask cancelTask) throws IOException {
        if (this.type == AggregationIF.Type.FORECAST_MODEL_COLLECTION) {
            for (Dataset nested : this.nestedDatasets) {
                nested.ncoord = 1;
            }
        }
        this.totalCoords = 0;
        for (Dataset nested : this.nestedDatasets) {
            this.totalCoords += nested.setStartEnd(this.totalCoords, cancelTask);
        }
    }

    @Override
    public synchronized boolean syncExtend(boolean force) throws IOException {
        if (!force && !this.timeToRescan()) {
            return false;
        }
        if (!this.rescan()) {
            return false;
        }
        if (this.getType() == AggregationIF.Type.FORECAST_MODEL_COLLECTION || this.getType() == AggregationIF.Type.FORECAST_MODEL_SINGLE) {
            this.syncDataset(null);
        }
        return true;
    }

    protected void syncDataset(CancelTask cancelTask) throws IOException {
    }

    @Override
    public synchronized boolean sync() throws IOException {
        if (!this.timeToRescan()) {
            return false;
        }
        if (!this.rescan()) {
            return false;
        }
        this.buildDataset(false, null);
        this.ncDataset.finish();
        if (this.ncDataset.getEnhanceMode() != NetcdfDataset.EnhanceMode.None) {
            this.ncDataset.clearCoordinateSystems();
            this.ncDataset.enhance(this.ncDataset.getEnhanceMode());
            this.ncDataset.finish();
        }
        return true;
    }

    protected boolean timeToRescan() {
        if (this.getType() == AggregationIF.Type.UNION) {
            if (this.debugSyncDetail) {
                System.out.println(" *Sync not needed for Union");
            }
            return false;
        }
        if (this.recheck == null) {
            if (this.debugSyncDetail) {
                System.out.println(" *Sync not needed, recheck is null");
            }
            return false;
        }
        Date now = new Date();
        Date lastCheckedDate = new Date(this.lastChecked);
        Date need = this.recheck.add(lastCheckedDate);
        if (now.before(need)) {
            if (this.debug) {
                System.out.println(" *Sync not needed, last= " + lastCheckedDate + " now = " + now);
            }
            return false;
        }
        return true;
    }

    protected boolean rescan() throws IOException {
        this.lastChecked = System.currentTimeMillis();
        if (this.debug) {
            System.out.println(" *Sync at " + new Date());
        }
        ArrayList<Dataset> newDatasets = new ArrayList<Dataset>();
        this.scan(newDatasets, null);
        boolean changed = false;
        for (int i = 0; i < newDatasets.size(); ++i) {
            Dataset newDataset = (Dataset)newDatasets.get(i);
            int index = this.nestedDatasets.indexOf(newDataset);
            if (index >= 0) {
                newDatasets.set(i, this.nestedDatasets.get(index));
                if (!this.debugSyncDetail) continue;
                System.out.println("  sync using old Dataset= " + newDataset.location);
                continue;
            }
            changed = true;
            if (!this.debugSyncDetail) continue;
            System.out.println("  sync found new Dataset= " + newDataset.location);
        }
        if (!changed) {
            for (Dataset oldDataset : this.nestedDatasets) {
                if (newDatasets.indexOf(oldDataset) >= 0 || this.explicitDatasets.indexOf(oldDataset) >= 0) continue;
                changed = true;
                if (!this.debugSyncDetail) continue;
                System.out.println("  sync found deleted Dataset= " + oldDataset.location);
            }
        }
        if (!changed) {
            return false;
        }
        this.nestedDatasets = new ArrayList<Dataset>();
        this.nestedDatasets.addAll(this.explicitDatasets);
        this.nestedDatasets.addAll(newDatasets);
        return true;
    }

    protected Dataset getTypicalDataset() throws IOException {
        int n = this.nestedDatasets.size();
        if (n == 0) {
            throw new FileNotFoundException("No datasets in this aggregation");
        }
        int select = typicalDatasetMode == TYPICAL_DATASET_LATEST ? n - 1 : (typicalDatasetMode == TYPICAL_DATASET_PENULTIMATE ? (n < 2 ? 0 : n - 2) : (n < 2 ? 0 : new Random().nextInt(n)));
        return this.nestedDatasets.get(select);
    }

    protected void makeProxies(Dataset typicalDataset, NetcdfDataset newds) throws IOException {
        DatasetProxyReader proxy = new DatasetProxyReader(typicalDataset);
        List<Variable> allVars = newds.getVariables();
        for (Variable v : allVars) {
            VariableEnhanced ve = (VariableEnhanced)((Object)v);
            if (ve.getProxyReader() != null) {
                if (!this.debugProxy) continue;
                System.out.println(" debugProxy: hasProxyReader " + ve.getName());
                continue;
            }
            if (v.isCaching()) {
                if (!v.hasCachedData()) {
                    ve.read();
                    if (!this.debugProxy) continue;
                    System.out.println(" debugProxy: cached " + ve.getName());
                    continue;
                }
                if (!this.debugProxy) continue;
                System.out.println(" debugProxy: already cached " + ve.getName());
                continue;
            }
            if (null != ve.getProxyReader()) continue;
            ve.setProxyReader(proxy);
            if (!this.debugProxy) continue;
            System.out.println(" debugProxy: proxy on " + ve.getName());
        }
    }

    @Override
    public Array read(Variable mainv, CancelTask cancelTask) throws IOException {
        if ((this.type == AggregationIF.Type.JOIN_NEW || this.type == AggregationIF.Type.JOIN_EXISTING || this.type == AggregationIF.Type.JOIN_EXISTING_ONE || this.type == AggregationIF.Type.FORECAST_MODEL_COLLECTION) && mainv.getShortName().equals(this.dimName)) {
            return this.readAggCoord(mainv, cancelTask);
        }
        DataType dtype = mainv instanceof VariableDS ? ((VariableDS)mainv).getOriginalDataType() : mainv.getDataType();
        Array allData = Array.factory(dtype, mainv.getShape());
        int destPos = 0;
        for (Dataset vnested : this.nestedDatasets) {
            Array varData = vnested.read(mainv, cancelTask);
            if (cancelTask != null && cancelTask.isCancel()) {
                return null;
            }
            Array.arraycopy(varData, 0, allData, destPos, (int)varData.getSize());
            destPos = (int)((long)destPos + varData.getSize());
        }
        return allData;
    }

    protected Array readAggCoord(Variable aggCoord, CancelTask cancelTask) throws IOException {
        DataType dtype = aggCoord.getDataType();
        Array allData = Array.factory(dtype, aggCoord.getShape());
        IndexIterator result = allData.getIndexIterator();
        for (Dataset vnested : this.nestedDatasets) {
            try {
                this.readAggCoord(aggCoord, cancelTask, vnested, dtype, result, null, null, null);
            }
            catch (InvalidRangeException e) {
                e.printStackTrace();
            }
            if (cancelTask == null || !cancelTask.isCancel()) continue;
            return null;
        }
        aggCoord.setCachedData(allData, false);
        return allData;
    }

    @Override
    public Array read(Variable mainv, Section section, CancelTask cancelTask) throws IOException, InvalidRangeException {
        long size = section.computeSize();
        if (size == mainv.getSize()) {
            return this.read(mainv, cancelTask);
        }
        if ((this.type == AggregationIF.Type.JOIN_NEW || this.type == AggregationIF.Type.JOIN_EXISTING || this.type == AggregationIF.Type.JOIN_EXISTING_ONE || this.type == AggregationIF.Type.FORECAST_MODEL_COLLECTION) && mainv.getShortName().equals(this.dimName)) {
            return this.readAggCoord(mainv, section, cancelTask);
        }
        DataType dtype = mainv instanceof VariableDS ? ((VariableDS)mainv).getOriginalDataType() : mainv.getDataType();
        Array sectionData = Array.factory(dtype, section.getShape());
        int destPos = 0;
        List<Range> ranges = section.getRanges();
        Range joinRange = section.getRange(0);
        ArrayList<Range> nestedSection = new ArrayList<Range>(ranges);
        List<Range> innerSection = ranges.subList(1, ranges.size());
        if (this.debug) {
            System.out.println("   agg wants range=" + mainv.getName() + "(" + joinRange + ")");
        }
        for (Dataset nested : this.nestedDatasets) {
            Array varData;
            Range nestedJoinRange = nested.getNestedJoinRange(joinRange);
            if (nestedJoinRange == null) continue;
            if (this.debug) {
                System.out.println("   agg use " + nested.aggStart + ":" + nested.aggEnd + " range= " + nestedJoinRange + " file " + nested.getLocation());
            }
            if (this.type == AggregationIF.Type.JOIN_NEW || this.type == AggregationIF.Type.FORECAST_MODEL_COLLECTION) {
                varData = nested.read(mainv, cancelTask, innerSection);
            } else {
                nestedSection.set(0, nestedJoinRange);
                varData = nested.read(mainv, cancelTask, nestedSection);
            }
            if (cancelTask != null && cancelTask.isCancel()) {
                return null;
            }
            Array.arraycopy(varData, 0, sectionData, destPos, (int)varData.getSize());
            destPos = (int)((long)destPos + varData.getSize());
        }
        return sectionData;
    }

    protected Array readAggCoord(Variable aggCoord, Section section, CancelTask cancelTask) throws IOException, InvalidRangeException {
        DataType dtype = aggCoord.getDataType();
        Array allData = Array.factory(dtype, section.getShape());
        IndexIterator result = allData.getIndexIterator();
        List<Range> ranges = section.getRanges();
        Range joinRange = section.getRange(0);
        ArrayList<Range> nestedSection = new ArrayList<Range>(ranges);
        List<Range> innerSection = ranges.subList(1, ranges.size());
        for (Dataset vnested : this.nestedDatasets) {
            Range nestedJoinRange = vnested.getNestedJoinRange(joinRange);
            if (nestedJoinRange == null) continue;
            if (this.debug) {
                System.out.println("   agg use " + vnested.aggStart + ":" + vnested.aggEnd + " range= " + nestedJoinRange + " file " + vnested.getLocation());
            }
            this.readAggCoord(aggCoord, cancelTask, vnested, dtype, result, nestedJoinRange, nestedSection, innerSection);
            if (cancelTask == null || !cancelTask.isCancel()) continue;
            return null;
        }
        return allData;
    }

    private void readAggCoord(Variable aggCoord, CancelTask cancelTask, Dataset vnested, DataType dtype, IndexIterator result, Range nestedJoinRange, List<Range> nestedSection, List<Range> innerSection) throws IOException, InvalidRangeException {
        if (vnested.coordValue != null) {
            if (this.type == AggregationIF.Type.JOIN_NEW || this.type == AggregationIF.Type.JOIN_EXISTING_ONE || this.type == AggregationIF.Type.FORECAST_MODEL_COLLECTION) {
                if (dtype == DataType.STRING) {
                    result.setObjectNext(vnested.coordValue);
                } else {
                    double val = Double.parseDouble(vnested.coordValue);
                    result.setDoubleNext(val);
                }
            } else {
                int count = 0;
                StringTokenizer stoker = new StringTokenizer(vnested.coordValue, " ,");
                while (stoker.hasMoreTokens()) {
                    String toke = stoker.nextToken();
                    if (nestedJoinRange != null && !nestedJoinRange.contains(count)) continue;
                    if (dtype == DataType.STRING) {
                        result.setObjectNext(toke);
                    } else {
                        double val = Double.parseDouble(toke);
                        result.setDoubleNext(val);
                    }
                    ++count;
                }
                if (count != vnested.ncoord) {
                    logger.error("readAggCoord incorrect number of coordinates dataset=" + vnested.location);
                }
            }
        } else {
            Array varData;
            if (nestedJoinRange == null) {
                varData = vnested.read(aggCoord, cancelTask);
            } else if (this.type == AggregationIF.Type.JOIN_NEW || this.type == AggregationIF.Type.JOIN_EXISTING_ONE || this.type == AggregationIF.Type.FORECAST_MODEL_COLLECTION) {
                varData = vnested.read(aggCoord, cancelTask, innerSection);
            } else {
                nestedSection.set(0, nestedJoinRange);
                varData = vnested.read(aggCoord, cancelTask, nestedSection);
            }
            MAMath.copy(dtype, varData.getIndexIterator(), result);
        }
    }

    protected void scan(List<Dataset> result, CancelTask cancelTask) throws IOException {
        ArrayList<MyFile> fileList = new ArrayList<MyFile>();
        for (DirectoryScan dir : this.scanList) {
            dir.scanDirectory(fileList, cancelTask);
            if (cancelTask == null || !cancelTask.isCancel()) continue;
            return;
        }
        for (MyFile myf : fileList) {
            if (null != myf.dir.dateFormatMark) {
                String filename = myf.file.getName();
                myf.dateCoord = DateFromString.getDateUsingDemarkatedCount(filename, myf.dir.dateFormatMark, '#');
                myf.dateCoordS = this.formatter.toDateTimeStringISO(myf.dateCoord);
                if (!this.debugScan) continue;
                System.out.println("  adding " + myf.file.getAbsolutePath() + " date= " + myf.dateCoordS);
                continue;
            }
            if (!this.debugScan) continue;
            System.out.println("  adding " + myf.file.getAbsolutePath());
        }
        Collections.sort(fileList, new Comparator<MyFile>(){

            @Override
            public int compare(MyFile mf1, MyFile mf2) {
                if (Aggregation.this.isDate) {
                    return mf1.dateCoord.compareTo(mf2.dateCoord);
                }
                return mf1.file.getName().compareTo(mf2.file.getName());
            }
        });
        for (MyFile myf : fileList) {
            String location = myf.file.getAbsolutePath();
            String coordValue = this.type == AggregationIF.Type.JOIN_NEW || this.type == AggregationIF.Type.JOIN_EXISTING_ONE || this.type == AggregationIF.Type.FORECAST_MODEL_COLLECTION ? myf.dateCoordS : null;
            Dataset ds = this.makeDataset(location, location, null, coordValue, myf.dir.enhance, null);
            ds.coordValueDate = myf.dateCoord;
            result.add(ds);
            if (cancelTask == null || !cancelTask.isCancel()) continue;
            return;
        }
    }

    protected Dataset makeDataset(String cacheName, String location, String ncoordS, String coordValueS, boolean enhance, NetcdfFileFactory reader) {
        return new Dataset(cacheName, location, ncoordS, coordValueS, enhance, reader);
    }

    protected class DatasetProxyReader
    implements ProxyReader {
        Dataset dataset;

        DatasetProxyReader(Dataset dataset) {
            this.dataset = dataset;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Array read(Variable mainV, CancelTask cancelTask) throws IOException {
            NetcdfFile ncfile = null;
            try {
                ncfile = this.dataset.acquireFile(cancelTask);
                if (cancelTask != null && cancelTask.isCancel()) {
                    Array array = null;
                    return array;
                }
                Variable proxyV = ncfile.findVariable(mainV.getName());
                Array array = proxyV.read();
                return array;
            }
            finally {
                if (ncfile != null) {
                    ncfile.close();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Array read(Variable mainV, Section section, CancelTask cancelTask) throws IOException, InvalidRangeException {
            NetcdfFile ncfile = null;
            try {
                ncfile = this.dataset.acquireFile(cancelTask);
                Variable proxyV = ncfile.findVariable(mainV.getName());
                if (cancelTask != null && cancelTask.isCancel()) {
                    Array array = null;
                    return array;
                }
                Array array = proxyV.read(section);
                return array;
            }
            finally {
                if (ncfile != null) {
                    ncfile.close();
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Dataset {
        private String location;
        private int aggStart = 0;
        private int aggEnd = 0;
        private String cacheName;
        private NetcdfFileFactory reader;
        private boolean enhance;
        protected int ncoord;
        protected String coordValue;
        protected Date coordValueDate;
        private boolean isStringValued = false;

        protected Dataset(String location) {
            this.location = location == null ? null : StringUtil.substitute(location, "\\", "/");
        }

        protected Dataset(String cacheName, String location, String ncoordS, String coordValueS, boolean enhance, NetcdfFileFactory reader) {
            this(location);
            this.cacheName = cacheName;
            this.coordValue = coordValueS;
            this.enhance = enhance;
            NetcdfFileFactory netcdfFileFactory = this.reader = reader != null ? reader : new PolymorphicReader();
            if (aggregation.type == AggregationIF.Type.JOIN_NEW || aggregation.type == AggregationIF.Type.JOIN_EXISTING_ONE) {
                this.ncoord = 1;
            } else if (ncoordS != null) {
                try {
                    this.ncoord = Integer.parseInt(ncoordS);
                }
                catch (NumberFormatException e) {
                    logger.error("bad ncoord attribute on dataset=" + location);
                }
            }
            if (aggregation.type == AggregationIF.Type.JOIN_NEW || aggregation.type == AggregationIF.Type.JOIN_EXISTING_ONE || aggregation.type == AggregationIF.Type.FORECAST_MODEL_COLLECTION) {
                if (coordValueS == null) {
                    int pos = this.location.lastIndexOf("/");
                    this.coordValue = pos < 0 ? this.location : this.location.substring(pos + 1);
                    this.isStringValued = true;
                } else {
                    try {
                        Double.parseDouble(coordValueS);
                    }
                    catch (NumberFormatException e) {
                        this.isStringValued = true;
                    }
                }
            }
            if (aggregation.type == AggregationIF.Type.JOIN_EXISTING && coordValueS != null) {
                StringTokenizer stoker = new StringTokenizer(coordValueS, " ,");
                this.ncoord = stoker.countTokens();
            }
        }

        public String getCoordValueString() {
            return this.coordValue;
        }

        public Date getCoordValueDate() {
            return this.coordValueDate;
        }

        public String getLocation() {
            return this.location;
        }

        public int getNcoords(CancelTask cancelTask) throws IOException {
            if (this.ncoord <= 0) {
                NetcdfFile ncd = this.acquireFile(cancelTask);
                if (cancelTask != null && cancelTask.isCancel()) {
                    return 0;
                }
                Dimension d = ncd.getRootGroup().findDimension(Aggregation.this.dimName);
                if (d != null) {
                    this.ncoord = d.getLength();
                }
                ncd.close();
            }
            return this.ncoord;
        }

        private int setStartEnd(int aggStart, CancelTask cancelTask) throws IOException {
            this.aggStart = aggStart;
            this.aggEnd = aggStart + this.getNcoords(cancelTask);
            return this.ncoord;
        }

        private Range getNestedJoinRange(Range totalRange) throws InvalidRangeException {
            int wantStop;
            int wantStart = totalRange.first();
            if (!this.isNeeded(wantStart, wantStop = totalRange.last() + 1)) {
                return null;
            }
            int firstInInterval = totalRange.getFirstInInterval(this.aggStart);
            if (firstInInterval < 0 || firstInInterval >= this.aggEnd) {
                return null;
            }
            int start = Math.max(this.aggStart, wantStart) - this.aggStart;
            int stop = Math.min(this.aggEnd, wantStop) - this.aggStart;
            return new Range(start, stop - 1, totalRange.stride());
        }

        protected boolean isNeeded(Range totalRange) {
            int wantStart = totalRange.first();
            int wantStop = totalRange.last() + 1;
            return this.isNeeded(wantStart, wantStop);
        }

        private boolean isNeeded(int wantStart, int wantStop) {
            if (wantStart >= wantStop) {
                return false;
            }
            return wantStart < this.aggEnd && wantStop > this.aggStart;
        }

        protected NetcdfFile acquireFile(CancelTask cancelTask) throws IOException {
            try {
                return this._acquireFile(cancelTask);
            }
            catch (IOException ioe) {
                Aggregation.this.syncExtend(true);
                throw ioe;
            }
        }

        private NetcdfFile _acquireFile(CancelTask cancelTask) throws IOException {
            long start = System.currentTimeMillis();
            if (Aggregation.this.debugOpenFile) {
                System.out.println(" try to acquire " + this.cacheName);
            }
            NetcdfFile ncfile = this.enhance ? NetcdfDatasetCache.acquire(this.cacheName, -1, cancelTask, Aggregation.this.spiObject, (NetcdfDatasetFactory)((Object)this.reader)) : NetcdfFileCache.acquire(this.cacheName, -1, cancelTask, Aggregation.this.spiObject, this.reader);
            if (Aggregation.this.debugOpenFile) {
                System.out.println(" acquire " + this.cacheName + " took " + (System.currentTimeMillis() - start));
            }
            if (Aggregation.this.type == AggregationIF.Type.JOIN_EXISTING) {
                this.cacheCoordValues(ncfile);
            }
            return ncfile;
        }

        protected void close() throws IOException {
        }

        private void cacheCoordValues(NetcdfFile ncfile) throws IOException {
            if (this.coordValue != null) {
                return;
            }
            Variable coordVar = ncfile.findVariable(Aggregation.this.dimName);
            if (coordVar != null) {
                Array data = coordVar.read();
                this.coordValue = data.toString();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Array read(Variable mainv, CancelTask cancelTask) throws IOException {
            NetcdfFile ncd = null;
            try {
                ncd = this.acquireFile(cancelTask);
                if (cancelTask != null && cancelTask.isCancel()) {
                    Array array = null;
                    return array;
                }
                Variable v = this.modifyVariable(ncd, mainv.getName());
                Array array = v.read();
                return array;
            }
            finally {
                if (ncd != null) {
                    ncd.close();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Array read(Variable mainv, CancelTask cancelTask, List<Range> section) throws IOException, InvalidRangeException {
            NetcdfFile ncd = null;
            try {
                ncd = this.acquireFile(cancelTask);
                if (cancelTask != null && cancelTask.isCancel()) {
                    Array array = null;
                    return array;
                }
                if (Aggregation.this.debugRead) {
                    System.out.print("agg read " + ncd.getLocation() + " nested= " + this.getLocation());
                    for (Range range : section) {
                        System.out.print(" " + range + ":");
                    }
                    System.out.println("");
                }
                Variable v = this.modifyVariable(ncd, mainv.getName());
                Range fullRange = v.getRanges().get(0);
                Range want = section.get(0);
                if (fullRange.last() < want.last()) {
                    Range limitRange = new Range(want.first(), fullRange.last(), want.stride());
                    section = new ArrayList<Range>(section);
                    section.set(0, limitRange);
                }
                Array array = v.read(section);
                return array;
            }
            finally {
                if (ncd != null) {
                    ncd.close();
                }
            }
        }

        public boolean equals(Object oo) {
            if (this == oo) {
                return true;
            }
            if (!(oo instanceof Dataset)) {
                return false;
            }
            Dataset other = (Dataset)oo;
            return this.location.equals(other.location);
        }

        public int hashCode() {
            return this.location.hashCode();
        }

        protected boolean checkOK(CancelTask cancelTask) throws IOException {
            return true;
        }

        protected Variable modifyVariable(NetcdfFile ncfile, String name) throws IOException {
            return ncfile.findVariable(name);
        }

        class PolymorphicReader
        implements NetcdfFileFactory,
        NetcdfDatasetFactory {
            PolymorphicReader() {
            }

            public NetcdfDataset openDataset(String location, int buffer_size, CancelTask cancelTask, Object spiObject) throws IOException {
                return NetcdfDataset.openDataset(location, true, buffer_size, cancelTask, spiObject);
            }

            public NetcdfFile open(String location, int buffer_size, CancelTask cancelTask, Object spiObject) throws IOException {
                return NetcdfDataset.openFile(location, buffer_size, cancelTask, spiObject);
            }
        }
    }

    protected class MyFile {
        DirectoryScan dir;
        File file;
        Date dateCoord;
        String dateCoordS;
        Date runDate;
        Double offset;

        MyFile(DirectoryScan dir, File file2) {
            this.dir = dir;
            this.file = file2;
        }

        public boolean equals(Object oo) {
            if (this == oo) {
                return true;
            }
            if (!(oo instanceof MyFile)) {
                return false;
            }
            MyFile other = (MyFile)oo;
            return this.file.equals(other.file);
        }

        public int hashCode() {
            return this.file.hashCode();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class DirectoryScan {
        String dirName;
        String dateFormatMark;
        String runMatcher;
        String forecastMatcher;
        String offsetMatcher;
        boolean enhance = false;
        boolean wantSubdirs = true;
        String suffix;
        Pattern regexpPattern = null;
        long olderThan_msecs;

        DirectoryScan(String dirName, String suffix, String regexpPatternString, String dateFormatMark, String enhanceS, String subdirsS, String olderS) {
            this.dirName = dirName;
            this.suffix = suffix;
            if (null != regexpPatternString) {
                this.regexpPattern = Pattern.compile(regexpPatternString);
            }
            this.dateFormatMark = dateFormatMark;
            if (enhanceS != null && enhanceS.equalsIgnoreCase("true")) {
                this.enhance = true;
            }
            if (subdirsS != null && subdirsS.equalsIgnoreCase("false")) {
                this.wantSubdirs = false;
            }
            if (Aggregation.this.type == AggregationIF.Type.FORECAST_MODEL_COLLECTION) {
                this.enhance = true;
            }
            if (olderS != null) {
                try {
                    TimeUnit tu = new TimeUnit(olderS);
                    this.olderThan_msecs = (long)(1000.0 * tu.getValueInSeconds());
                }
                catch (Exception e) {
                    logger.error("Invalid time unit for olderThan = {}", (Object)olderS);
                }
            }
        }

        DirectoryScan(String dirName, String suffix, String regexpPatternString, String subdirsS, String olderS, String runMatcher, String forecastMatcher, String offsetMatcher) {
            this(dirName, suffix, regexpPatternString, null, "true", subdirsS, olderS);
            this.runMatcher = runMatcher;
            this.forecastMatcher = forecastMatcher;
            this.offsetMatcher = offsetMatcher;
        }

        protected void scanDirectory(List<MyFile> result, CancelTask cancelTask) {
            this.scanDirectory(this.dirName, new Date().getTime(), result, cancelTask);
        }

        protected void scanDirectory(String dirName, long now, List<MyFile> result, CancelTask cancelTask) {
            File allDir = new File(dirName);
            if (!allDir.exists()) {
                String tmpMsg = "Non-existent scan location <" + dirName + "> for aggregation <" + Aggregation.this.ncDataset.getLocation() + ">.";
                logger.error("scanDirectory(): " + tmpMsg);
                throw new IllegalArgumentException(tmpMsg);
            }
            for (File f : allDir.listFiles()) {
                String location = f.getAbsolutePath();
                if (f.isDirectory()) {
                    if (this.wantSubdirs) {
                        this.scanDirectory(location, now, result, cancelTask);
                    }
                } else if (this.accept(location)) {
                    long lastModified;
                    if (this.olderThan_msecs > 0L && now - (lastModified = f.lastModified()) < this.olderThan_msecs) continue;
                    result.add(new MyFile(this, f));
                }
                if (cancelTask == null || !cancelTask.isCancel()) continue;
                return;
            }
        }

        protected boolean accept(String location) {
            if (null != this.regexpPattern) {
                Matcher matcher = this.regexpPattern.matcher(location);
                return matcher.matches();
            }
            return this.suffix == null || location.endsWith(this.suffix);
        }
    }

    protected class MyReplaceVariableCheck
    implements ReplaceVariableCheck {
        protected MyReplaceVariableCheck() {
        }

        public boolean replace(Variable v) {
            if (Aggregation.this.getType() == AggregationIF.Type.JOIN_NEW) {
                return Aggregation.this.isAggVariable(v.getName());
            }
            if (v.getRank() < 1) {
                return true;
            }
            Dimension d = v.getDimension(0);
            return !Aggregation.this.getDimensionName().equals(d.getName());
        }
    }
}

