/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.geoloc.vertical;

import java.io.IOException;
import ucar.ma2.Array;
import ucar.ma2.ArrayDouble;
import ucar.ma2.Index;
import ucar.ma2.InvalidRangeException;
import ucar.nc2.Dimension;
import ucar.nc2.Variable;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.VerticalCT;
import ucar.unidata.geoloc.vertical.VerticalTransformImpl;

public class HybridHeight
extends VerticalTransformImpl {
    public static final String OROG = "Orography_variableName";
    public static final String A = "A_variableName";
    public static final String B = "B_variableName";
    private Variable aVar;
    private Variable bVar;
    private Variable orogVar;
    private Array aArray = null;
    private Array bArray = null;

    public HybridHeight(NetcdfDataset ds, Dimension timeDim, VerticalCT vCT) {
        super(timeDim);
        String aName = vCT.findParameterIgnoreCase(A).getStringValue();
        String bName = vCT.findParameterIgnoreCase(B).getStringValue();
        String orogName = vCT.findParameterIgnoreCase(OROG).getStringValue();
        this.aVar = ds.findStandardVariable(aName);
        this.bVar = ds.findStandardVariable(bName);
        this.orogVar = ds.findStandardVariable(orogName);
        this.units = ds.findAttValueIgnoreCase(this.orogVar, "units", "none");
    }

    public ArrayDouble.D3 getCoordinateArray(int timeIndex) throws IOException, InvalidRangeException {
        Array orogArray = this.readArray(this.orogVar, timeIndex);
        if (null == this.aArray) {
            this.aArray = this.aVar.read();
            this.bArray = this.bVar.read();
        }
        int nz = (int)this.aArray.getSize();
        Index aIndex = this.aArray.getIndex();
        Index bIndex = this.bArray.getIndex();
        int[] shape2D = orogArray.getShape();
        int ny = shape2D[0];
        int nx = shape2D[1];
        Index orogIndex = orogArray.getIndex();
        ArrayDouble.D3 height = new ArrayDouble.D3(nz, ny, nx);
        for (int z = 0; z < nz; ++z) {
            double az = this.aArray.getDouble(aIndex.set(z));
            double bz = this.bArray.getDouble(bIndex.set(z));
            for (int y = 0; y < ny; ++y) {
                for (int x = 0; x < nx; ++x) {
                    double orog = orogArray.getDouble(orogIndex.set(y, x));
                    height.set(z, y, x, az + bz * orog);
                }
            }
        }
        return height;
    }
}

