/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.list;

import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import org.apache.commons.collections.collection.SynchronizedCollection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SynchronizedList<E>
extends SynchronizedCollection<E>
implements List<E> {
    private static final long serialVersionUID = -1403835447328619437L;

    public static <E> List<E> decorate(List<E> list) {
        return new SynchronizedList<E>(list);
    }

    protected SynchronizedList(List<E> list) {
        super(list);
    }

    protected SynchronizedList(List<E> list, Object lock) {
        super(list, lock);
    }

    protected List<E> getList() {
        return (List)this.collection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(int index, E object) {
        Object object2 = this.lock;
        synchronized (object2) {
            this.getList().add(index, object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAll(int index, Collection<? extends E> coll) {
        Object object = this.lock;
        synchronized (object) {
            return this.getList().addAll(index, coll);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E get(int index) {
        Object object = this.lock;
        synchronized (object) {
            return this.getList().get(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int indexOf(Object object) {
        Object object2 = this.lock;
        synchronized (object2) {
            return this.getList().indexOf(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int lastIndexOf(Object object) {
        Object object2 = this.lock;
        synchronized (object2) {
            return this.getList().lastIndexOf(object);
        }
    }

    @Override
    public ListIterator<E> listIterator() {
        return this.getList().listIterator();
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        return this.getList().listIterator(index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E remove(int index) {
        Object object = this.lock;
        synchronized (object) {
            return this.getList().remove(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E set(int index, E object) {
        Object object2 = this.lock;
        synchronized (object2) {
            return this.getList().set(index, object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        Object object = this.lock;
        synchronized (object) {
            List<E> list = this.getList().subList(fromIndex, toIndex);
            return new SynchronizedList<E>(list, this.lock);
        }
    }
}

