/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImageJ;
import ij.ImagePlus;
import ij.Prefs;
import ij.gui.GenericDialog;
import ij.plugin.PlugIn;
import ij.process.ImageProcessor;
import java.awt.Button;
import java.awt.FlowLayout;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;

public class BatchConverter
implements PlugIn,
ActionListener {
    private static final String[] formats = new String[]{"TIFF", "8-bit TIFF", "JPEG", "GIF", "PNG", "PGM", "BMP", "FITS", "Text Image", "ZIP", "Raw"};
    private static String format = formats[0];
    private static double scale = 1.0;
    private static int interpolationMethod = 1;
    private String[] methods = ImageProcessor.getInterpolationMethods();
    private Button input;
    private Button output;
    private TextField inputDir;
    private TextField outputDir;
    private GenericDialog gd;

    public void run(String arg) {
        if (!this.showDialog()) {
            return;
        }
        String inputPath = this.inputDir.getText();
        if (inputPath.equals("")) {
            IJ.error("Batch Converter", "Please choose an input folder");
            return;
        }
        String outputPath = this.outputDir.getText();
        if (outputPath.equals("")) {
            IJ.error("Batch Converter", "Please choose an output folder");
            return;
        }
        File f1 = new File(inputPath);
        if (!f1.exists() || !f1.isDirectory()) {
            IJ.error("Batch Converter", "Input does not exist or is not a folder\n \n" + inputPath);
            return;
        }
        File f2 = new File(outputPath);
        if (!(outputPath.equals("") || f2.exists() && f2.isDirectory())) {
            IJ.error("Batch Converter", "Output does not exist or is not a folder\n \n" + outputPath);
            return;
        }
        String[] list = new File(inputPath).list();
        ImageJ ij = IJ.getInstance();
        if (ij != null) {
            ij.getProgressBar().setBatchMode(true);
        }
        IJ.resetEscape();
        for (int i = 0; i < list.length && !IJ.escapePressed(); ++i) {
            String path;
            if (IJ.debugMode) {
                IJ.log(i + "  " + list[i]);
            }
            if (new File(path = inputPath + list[i]).isDirectory() || list[i].startsWith(".") || list[i].endsWith(".avi") || list[i].endsWith(".AVI")) continue;
            IJ.showProgress(i + 1, list.length);
            ImagePlus imp = IJ.openImage(path);
            if (imp == null) continue;
            if (scale != 1.0) {
                int width = (int)(scale * (double)imp.getWidth());
                int height = (int)(scale * (double)imp.getHeight());
                ImageProcessor ip = imp.getProcessor();
                ip.setInterpolationMethod(interpolationMethod);
                imp.setProcessor(null, ip.resize(width, height));
            }
            if (format.equals("8-bit TIFF") || format.equals("GIF")) {
                if (imp.getBitDepth() == 24) {
                    IJ.run(imp, "8-bit Color", "number=256");
                } else {
                    IJ.run(imp, "8-bit", "");
                }
            }
            IJ.saveAs(imp, format, outputPath + list[i]);
            imp.close();
        }
        IJ.showProgress(1, 1);
        Prefs.set("batch.input", this.inputDir.getText());
        Prefs.set("batch.output", this.outputDir.getText());
    }

    boolean showDialog() {
        this.gd = new GenericDialog("Batch Convert");
        this.addPanels(this.gd);
        this.gd.setInsets(15, 0, 5);
        this.gd.addChoice("Output Format: ", formats, format);
        this.gd.addChoice("Interpolation:", this.methods, this.methods[interpolationMethod]);
        this.gd.addNumericField("Scale Factor: ", scale, 2);
        this.gd.setOKLabel("Convert");
        this.gd.showDialog();
        format = this.gd.getNextChoice();
        interpolationMethod = this.gd.getNextChoiceIndex();
        scale = this.gd.getNextNumber();
        return !this.gd.wasCanceled();
    }

    void addPanels(GenericDialog gd) {
        Panel p = new Panel();
        p.setLayout(new FlowLayout(1, 5, 0));
        this.input = new Button("Input...");
        this.input.addActionListener(this);
        p.add(this.input);
        this.inputDir = new TextField(Prefs.get("batch.input", ""), 45);
        p.add(this.inputDir);
        gd.addPanel(p);
        p = new Panel();
        p.setLayout(new FlowLayout(1, 5, 0));
        this.output = new Button("Output...");
        this.output.addActionListener(this);
        p.add(this.output);
        this.outputDir = new TextField(Prefs.get("batch.output", ""), 45);
        p.add(this.outputDir);
        gd.addPanel(p);
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        String s = source == this.input ? "Input" : "Output";
        String path = IJ.getDirectory(s + " Folder");
        if (path == null) {
            return;
        }
        if (source == this.input) {
            this.inputDir.setText(path);
        } else {
            this.outputDir.setText(path);
        }
        if (IJ.isMacOSX()) {
            this.gd.setVisible(false);
            this.gd.setVisible(true);
        }
    }
}

