/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jsonrpc4j;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class ReflectionUtil {
    private static Map<String, Set<Method>> methodCache = new HashMap<String, Set<Method>>();
    private static Map<Method, List<Class<?>>> parameterTypeCache = new HashMap();
    private static Map<Method, List<Annotation>> methodAnnotationCache = new HashMap<Method, List<Annotation>>();
    private static Map<Method, List<List<Annotation>>> methodParamAnnotationCache = new HashMap<Method, List<List<Annotation>>>();

    public static Set<Method> findMethods(Class<?> clazz, String name) {
        String cacheKey = clazz.getName().concat("::").concat(name);
        if (methodCache.containsKey(cacheKey)) {
            return methodCache.get(cacheKey);
        }
        HashSet<Method> methods = new HashSet();
        Method[] methodArray = clazz.getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (method.getName().equals(name)) {
                methods.add(method);
            }
            ++n2;
        }
        methods = Collections.unmodifiableSet(methods);
        methodCache.put(cacheKey, methods);
        return methods;
    }

    public static List<Class<?>> getParameterTypes(Method method) {
        if (parameterTypeCache.containsKey(method)) {
            return parameterTypeCache.get(method);
        }
        List<Class<?>> types = new ArrayList();
        Class<?>[] classArray = method.getParameterTypes();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> type = classArray[n2];
            types.add(type);
            ++n2;
        }
        types = Collections.unmodifiableList(types);
        parameterTypeCache.put(method, types);
        return types;
    }

    public static List<Annotation> getAnnotations(Method method) {
        if (methodAnnotationCache.containsKey(method)) {
            return methodAnnotationCache.get(method);
        }
        List<Annotation> annotations = new ArrayList();
        Annotation[] annotationArray = method.getAnnotations();
        int n = annotationArray.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation a = annotationArray[n2];
            annotations.add(a);
            ++n2;
        }
        annotations = Collections.unmodifiableList(annotations);
        methodAnnotationCache.put(method, annotations);
        return annotations;
    }

    public static <T extends Annotation> List<T> getAnnotations(Method method, Class<T> type) {
        ArrayList<Annotation> ret = new ArrayList<Annotation>();
        for (Annotation a : ReflectionUtil.getAnnotations(method)) {
            if (!type.isInstance(a)) continue;
            ret.add((Annotation)type.cast(a));
        }
        return ret;
    }

    public static <T extends Annotation> T getAnnotation(Method method, Class<T> type) {
        for (Annotation a : ReflectionUtil.getAnnotations(method)) {
            if (!type.isInstance(a)) continue;
            return (T)((Annotation)type.cast(a));
        }
        return null;
    }

    public static List<List<Annotation>> getParameterAnnotations(Method method) {
        if (methodParamAnnotationCache.containsKey(method)) {
            return methodParamAnnotationCache.get(method);
        }
        ArrayList<List<Annotation>> annotations = new ArrayList();
        Annotation[][] annotationArray = method.getParameterAnnotations();
        int n = annotationArray.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation[] paramAnnotations = annotationArray[n2];
            ArrayList<Annotation> listAnnotations = new ArrayList<Annotation>();
            Annotation[] annotationArray2 = paramAnnotations;
            int n3 = paramAnnotations.length;
            int n4 = 0;
            while (n4 < n3) {
                Annotation a = annotationArray2[n4];
                listAnnotations.add(a);
                ++n4;
            }
            annotations.add(listAnnotations);
            ++n2;
        }
        annotations = Collections.unmodifiableList(annotations);
        methodParamAnnotationCache.put(method, annotations);
        return annotations;
    }

    public static <T extends Annotation> List<List<T>> getParameterAnnotations(Method method, Class<T> type) {
        ArrayList<List<T>> annotations = new ArrayList<List<T>>();
        for (List<Annotation> paramAnnotations : ReflectionUtil.getParameterAnnotations(method)) {
            ArrayList<Annotation> listAnnotations = new ArrayList<Annotation>();
            for (Annotation a : paramAnnotations) {
                if (!type.isInstance(a)) continue;
                listAnnotations.add((Annotation)type.cast(a));
            }
            annotations.add(listAnnotations);
        }
        return annotations;
    }
}

