/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.translator;

import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityHistory;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.PropertyType;
import ch.systemsx.cisd.openbis.generic.shared.dto.AbstractEntityHistoryPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.AbstractEntityPropertyHistoryPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.ExperimentPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.PropertyTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SamplePE;
import ch.systemsx.cisd.openbis.generic.shared.managed_property.IManagedPropertyEvaluatorFactory;
import ch.systemsx.cisd.openbis.generic.shared.translator.DataSetTranslator;
import ch.systemsx.cisd.openbis.generic.shared.translator.ExperimentTranslator;
import ch.systemsx.cisd.openbis.generic.shared.translator.PersonTranslator;
import ch.systemsx.cisd.openbis.generic.shared.translator.ProjectTranslator;
import ch.systemsx.cisd.openbis.generic.shared.translator.PropertyTypeTranslator;
import ch.systemsx.cisd.openbis.generic.shared.translator.SampleTranslator;
import ch.systemsx.cisd.openbis.generic.shared.translator.SpaceTranslator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EntityHistoryTranslator {
    public static List<EntityHistory> translate(List<AbstractEntityPropertyHistoryPE> history, String baseIndexURL, IManagedPropertyEvaluatorFactory managedPropertyEvaluatorFactory) {
        ArrayList<EntityHistory> result = new ArrayList<EntityHistory>();
        HashMap<PropertyTypePE, PropertyType> cache = new HashMap<PropertyTypePE, PropertyType>();
        for (AbstractEntityPropertyHistoryPE entityPropertyHistory : history) {
            result.add(EntityHistoryTranslator.translate(entityPropertyHistory, cache, baseIndexURL, managedPropertyEvaluatorFactory));
        }
        return result;
    }

    private static EntityHistory translate(AbstractEntityPropertyHistoryPE entityPropertyHistory, Map<PropertyTypePE, PropertyType> cache, String baseIndexURL, IManagedPropertyEvaluatorFactory managedPropertyEvaluatorFactory) {
        EntityHistory result = new EntityHistory();
        result.setAuthor(PersonTranslator.translate(entityPropertyHistory.getAuthor()));
        result.setValidFromDate(entityPropertyHistory.getValidFromDate());
        result.setValidUntilDate(entityPropertyHistory.getValidUntilDate());
        result.setValue(entityPropertyHistory.getValue());
        result.setMaterial(entityPropertyHistory.getMaterial());
        result.setVocabularyTerm(entityPropertyHistory.getVocabularyTerm());
        if (entityPropertyHistory.getEntityTypePropertyType() != null) {
            result.setPropertyType(PropertyTypeTranslator.translate(entityPropertyHistory.getEntityTypePropertyType().getPropertyType(), cache));
        }
        if (entityPropertyHistory instanceof AbstractEntityHistoryPE) {
            AbstractEntityHistoryPE entityHistory = (AbstractEntityHistoryPE)entityPropertyHistory;
            result.setRelatedEntityPermId(entityHistory.getEntityPermId());
            String entityType = null;
            if (entityHistory.getRelatedEntity() != null) {
                switch (entityHistory.getRelatedEntity().getEntityKind()) {
                    case DATA_SET: {
                        entityType = EntityKind.DATA_SET.getDescription();
                        result.setRelatedEntity(DataSetTranslator.translateBasicProperties((DataPE)entityHistory.getRelatedEntity()));
                        break;
                    }
                    case EXPERIMENT: {
                        entityType = EntityKind.EXPERIMENT.getDescription();
                        result.setRelatedEntity(ExperimentTranslator.translate((ExperimentPE)entityHistory.getRelatedEntity(), baseIndexURL, null, managedPropertyEvaluatorFactory, new ExperimentTranslator.LoadableFields[0]));
                        break;
                    }
                    case SAMPLE: {
                        entityType = EntityKind.SAMPLE.getDescription();
                        result.setRelatedEntity(SampleTranslator.translate((SamplePE)entityHistory.getRelatedEntity(), baseIndexURL, null, managedPropertyEvaluatorFactory));
                    }
                }
            }
            if (entityHistory.getSpace() != null) {
                entityType = "Space";
                result.setRelatedSpace(SpaceTranslator.translate(entityHistory.getSpace()));
            }
            if (entityHistory.getProject() != null) {
                entityType = "Project";
                result.setRelatedProject(ProjectTranslator.translate(entityHistory.getProject()));
            }
            if (entityHistory.getRelationType() != null) {
                result.setRelationType(entityHistory.getRelationType().getDescrption(entityType));
            }
        }
        return result;
    }
}

