/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.cisd.hotdeploy;

import ch.ethz.cisd.hotdeploy.PluginContainer;
import ch.ethz.cisd.hotdeploy.PluginEvent;
import ch.ethz.cisd.hotdeploy.PluginInfoProvider;
import java.io.File;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PluginHolder<T>
extends PluginInfoProvider {
    private static final Log log = LogFactory.getLog(PluginHolder.class);
    private final Class<T> workerInterface;
    private final Object[] constructorArgs;
    private T instance;

    public PluginHolder(PluginContainer container, String pluginName, Class<T> pluginInterface, Object ... constructorArgs) {
        this(container, pluginName, false, pluginInterface, constructorArgs);
    }

    public PluginHolder(PluginContainer container, String pluginName, boolean isClassName, Class<T> workerInterface, Object ... constructorArgs) {
        super(container, pluginName, isClassName);
        this.workerInterface = workerInterface;
        this.constructorArgs = constructorArgs;
        this.instance = container.tryCreatePluginByClassname(pluginName, workerInterface, constructorArgs);
    }

    @Override
    protected void processEvent(PluginEvent event) {
        if (event.isRegistrationOrUpdateEvent()) {
            T newInstance;
            T t = newInstance = this.isClassName ? this.container.tryCreatePluginByClassname(this.pluginName, this.workerInterface, this.constructorArgs) : this.container.tryCreatePlugin(this.pluginName, this.workerInterface, this.constructorArgs);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Set new plugin instance for plugin " + this.pluginName));
            }
            this.setInstance(newInstance, event);
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Remove plugin instance for plugin " + this.pluginName));
            }
            this.setInstance(null, event);
        }
        super.processEvent(event);
    }

    synchronized void setInstance(T newInstance, PluginEvent event) {
        this.instance = newInstance;
    }

    public synchronized T tryGetInstance() {
        return this.instance;
    }

    public byte[] tryGetResource(String resource) {
        File pluginArchive = this.isClassName ? this.container.tryGetPluginArchiveByClassname(this.pluginName) : this.container.tryGetPluginArchive(this.pluginName);
        return this.container.tryGetPluginResource(pluginArchive, resource);
    }

    public void refresh(boolean synchronous) {
        this.container.refresh(synchronous);
    }
}

