/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.monitoring;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class ThreadDump {
    public static void dumpAllThreads() {
        PrintWriter writer = new PrintWriter(System.out);
        ThreadDump.dumpAllThreads(writer);
        writer.flush();
    }

    public static void dumpAllThreads(Logger logger) {
        if (!logger.isInfoEnabled()) {
            return;
        }
        StringWriter stringWriter = new StringWriter();
        PrintWriter writer = new PrintWriter(stringWriter);
        ThreadDump.dumpAllThreads(writer);
        writer.flush();
        logger.info((Object)("Thread dump:\n" + stringWriter.toString()));
    }

    public static void dumpAllThreads(PrintWriter writer) {
        Map<Thread, StackTraceElement[]> allStackTraces = Thread.getAllStackTraces();
        Set<Map.Entry<Thread, StackTraceElement[]>> allDumps = allStackTraces.entrySet();
        for (Map.Entry entry : allDumps) {
            StackTraceElement[] stackTraceElements;
            Thread thread = (Thread)entry.getKey();
            Thread.State state = thread.getState();
            writer.println(thread + ", state:" + (Object)((Object)Thread.State.valueOf(state.name())) + ", daemon:" + thread.isDaemon() + ", alive:" + thread.isAlive() + ", interrupted:" + thread.isInterrupted());
            StackTraceElement[] stackTraceElementArray = stackTraceElements = (StackTraceElement[])entry.getValue();
            int n = stackTraceElements.length;
            int n2 = 0;
            while (n2 < n) {
                StackTraceElement stackTraceElement = stackTraceElementArray[n2];
                writer.println("\tat " + stackTraceElement);
                ++n2;
            }
            writer.println();
        }
    }
}

