/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver.validation;

import ch.systemsx.cisd.common.exceptions.ConfigurationFailureException;
import ch.systemsx.cisd.common.properties.PropertyParametersUtil;
import ch.systemsx.cisd.common.properties.PropertyUtils;
import ch.systemsx.cisd.etlserver.validation.IValidator;
import ch.systemsx.cisd.etlserver.validation.IValidatorFactory;
import ch.systemsx.cisd.etlserver.validation.UniqueGroupValidator;
import java.util.ArrayList;
import java.util.Properties;

class UniqueGroupValidatorFactory
implements IValidatorFactory {
    static final String GROUPS_KEY = "groups";
    private final String regex;
    private final ArrayList<Integer> groups;

    UniqueGroupValidatorFactory(Properties properties) {
        this.regex = PropertyUtils.getMandatoryProperty(properties, "value-pattern");
        String groupsParameter = PropertyUtils.getMandatoryProperty(properties, GROUPS_KEY);
        String[] uncheckedGroups = PropertyParametersUtil.parseItemisedProperty(groupsParameter, GROUPS_KEY);
        this.groups = new ArrayList();
        String[] stringArray = uncheckedGroups;
        int n = uncheckedGroups.length;
        int n2 = 0;
        while (n2 < n) {
            int value;
            String g = stringArray[n2];
            try {
                value = Integer.parseInt(g);
            }
            catch (NumberFormatException numberFormatException) {
                throw new ConfigurationFailureException(this.createIllegalGroupMessage(g));
            }
            if (value < 1) {
                throw new ConfigurationFailureException(this.createIllegalGroupMessage(g));
            }
            this.groups.add(value);
            ++n2;
        }
    }

    private String createIllegalGroupMessage(String g) {
        return "Illegal group: " + g;
    }

    @Override
    public IValidator createValidator(String header) {
        return new UniqueGroupValidator(this.regex, this.groups);
    }
}

