/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.server;

import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.string.ReflectingStringEscaper;
import ch.systemsx.cisd.openbis.generic.client.web.client.IClientService;
import ch.systemsx.cisd.openbis.generic.shared.basic.annotation.DoNotEscape;
import java.lang.reflect.Method;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.log4j.Logger;
import org.springframework.aop.ClassFilter;
import org.springframework.aop.Pointcut;
import org.springframework.aop.support.DefaultPointcutAdvisor;
import org.springframework.aop.support.RootClassFilter;
import org.springframework.aop.support.StaticMethodMatcherPointcut;

public class StringHtmlEscapingPointcutAdvisor
extends DefaultPointcutAdvisor {
    private static final long serialVersionUID = 1L;
    private static final Logger escapeLog = LogFactory.getLogger(LogCategory.OPERATION, StringHtmlEscapingPointcutAdvisor.class);

    public StringHtmlEscapingPointcutAdvisor() {
        this(new StringHtmlEscapingPointcutAdvisorMethodInterceptor());
    }

    public StringHtmlEscapingPointcutAdvisor(MethodInterceptor methodInterceptor) {
        super((Pointcut)new ClientServiceMatchingPointcut(), (Advice)methodInterceptor);
    }

    private static class ClientServiceMatchingPointcut
    extends StaticMethodMatcherPointcut {
        private ClientServiceMatchingPointcut() {
        }

        public ClassFilter getClassFilter() {
            return new RootClassFilter(IClientService.class);
        }

        public boolean matches(Method method, Class targetClass) {
            if (method.getReturnType() == Void.TYPE) {
                return false;
            }
            return !method.getReturnType().isAnnotationPresent(DoNotEscape.class);
        }
    }

    public static class StringHtmlEscapingPointcutAdvisorMethodInterceptor
    implements MethodInterceptor {
        public Object invoke(MethodInvocation methodInvocation) throws Throwable {
            Object result = methodInvocation.proceed();
            if (result != null) {
                result = this.escapeObject(methodInvocation, result);
            }
            return result;
        }

        private Object escapeObject(MethodInvocation methodInvocation, Object originalResult) {
            Object result = originalResult;
            escapeLog.debug((Object)(String.valueOf(methodInvocation.getMethod().getName()) + " converting   " + originalResult));
            if (!(originalResult instanceof String)) {
                ReflectingStringEscaper.escapeDeep(originalResult);
            }
            escapeLog.debug((Object)(String.valueOf(methodInvocation.getMethod().getName()) + " converted to " + result));
            return result;
        }
    }
}

