/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared;

import ch.systemsx.cisd.authentication.ILogMessagePrefixGenerator;
import ch.systemsx.cisd.authentication.ISessionManager;
import ch.systemsx.cisd.common.collection.CollectionUtils;
import ch.systemsx.cisd.common.exceptions.InvalidSessionException;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.openbis.common.spring.IInvocationLoggerContext;
import ch.systemsx.cisd.openbis.generic.shared.IServer;
import ch.systemsx.cisd.openbis.generic.shared.LogMessagePrefixGenerator;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DisplaySettings;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.GridCustomColumn;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.displaysettings.IDisplaySettingsUpdate;
import ch.systemsx.cisd.openbis.generic.shared.dto.IAuthSession;
import ch.systemsx.cisd.openbis.generic.shared.dto.Session;
import ch.systemsx.cisd.openbis.generic.shared.dto.SessionContextDTO;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public abstract class AbstractServerLogger
implements IServer {
    private static final String RESULT_SUCCESS = "";
    private static final String RESULT_FAILURE = " ...FAILED";
    private final Logger authLog;
    private final Logger accessLog;
    private final Logger trackingLog;
    protected final ILogMessagePrefixGenerator<Session> logMessagePrefixGenerator;
    private final ISessionManager<Session> sessionManagerOrNull;
    private final IInvocationLoggerContext context;
    private final String prefixOrNull;

    public AbstractServerLogger(ISessionManager<Session> sessionManagerNull, IInvocationLoggerContext context) {
        this.sessionManagerOrNull = sessionManagerNull;
        this.context = context;
        this.logMessagePrefixGenerator = new LogMessagePrefixGenerator();
        String sessionTokenOrNull = context.tryToGetSessionToken();
        this.prefixOrNull = this.tryToCreatePrefix(sessionTokenOrNull);
        this.authLog = LogFactory.getLogger(LogCategory.AUTH, this.getClass());
        this.accessLog = LogFactory.getLogger(LogCategory.ACCESS, this.getClass());
        this.trackingLog = LogFactory.getLogger(LogCategory.TRACKING, this.getClass());
    }

    protected String abbreviate(Collection<?> c) {
        if (c == null) {
            return "null";
        }
        return CollectionUtils.abbreviate(c, 10);
    }

    protected String abbreviate(Object[] object) {
        return CollectionUtils.abbreviate(object, 10);
    }

    protected int size(Collection<?> c) {
        if (c == null) {
            return 0;
        }
        return c.size();
    }

    protected int size(Object[] t) {
        if (t == null) {
            return 0;
        }
        return t.length;
    }

    private String tryToCreatePrefix(String sessionTokenOrNull) {
        if (sessionTokenOrNull == null) {
            return null;
        }
        return this.tryToCreatePrefixFromSession(sessionTokenOrNull);
    }

    private String tryToCreatePrefixSecondTime(String sessionToken) {
        if (this.prefixOrNull != null) {
            return this.prefixOrNull;
        }
        return this.tryToCreatePrefixFromSession(sessionToken);
    }

    private String tryToCreatePrefixFromSession(String sessionToken) {
        if (this.sessionManagerOrNull == null || !this.sessionManagerOrNull.isAWellFormedSessionToken(sessionToken)) {
            return "[SESSION:" + sessionToken + "]";
        }
        Session session = this.sessionManagerOrNull.tryGetSession(sessionToken);
        return session == null ? "[NO SESSION]" : this.logMessagePrefixGenerator.createPrefix(session);
    }

    protected final void logAuth(String sessionToken, String commandName, String parameterDisplayFormat, Object ... parameters) {
        this.logMessage(this.authLog, Level.INFO, sessionToken, commandName, parameterDisplayFormat, parameters);
    }

    protected final void logAccess(String sessionToken, String commandName) {
        this.logAccess(sessionToken, commandName, RESULT_SUCCESS, new Object[0]);
    }

    protected final void logAccess(String sessionToken, String commandName, String parameterDisplayFormat, Object ... parameters) {
        this.logMessage(this.accessLog, Level.INFO, sessionToken, commandName, parameterDisplayFormat, parameters);
    }

    protected final void logAccess(Level level, String sessionToken, String commandName, String parameterDisplayFormat, Object ... parameters) {
        this.logMessage(this.accessLog, level, sessionToken, commandName, parameterDisplayFormat, parameters);
    }

    protected final void logTracking(String sessionToken, String commandName, String parameterDisplayFormat, Object ... parameters) {
        this.logMessage(this.trackingLog, Level.INFO, sessionToken, commandName, parameterDisplayFormat, parameters);
    }

    private final void logMessage(Logger logger, Level level, String sessionToken, String commandName, String parameterDisplayFormat, Object[] parameters) {
        if (!logger.isEnabledFor((Priority)level)) {
            return;
        }
        int i = 0;
        while (i < parameters.length) {
            Object parameter = parameters[i];
            parameters[i] = parameter == null ? "<UNDEFINED>" : "'" + parameter + "'";
            ++i;
        }
        String message = String.format(parameterDisplayFormat, parameters);
        String invocationStatusMessage = this.getInvocationStatusMessage();
        String elapsedTimeMessage = this.getElapsedTimeMessage();
        logger.log((Priority)level, (Object)(String.valueOf(this.tryToCreatePrefixSecondTime(sessionToken)) + String.format(": (%s) %s  %s%s", elapsedTimeMessage, commandName, message, invocationStatusMessage)));
    }

    private String getInvocationStatusMessage() {
        return this.context.invocationWasSuccessful() ? RESULT_SUCCESS : RESULT_FAILURE;
    }

    private String getElapsedTimeMessage() {
        return String.valueOf(this.context.getElapsedTime()) + "ms";
    }

    @Override
    public final IAuthSession getAuthSession(String sessionToken) throws UserFailureException {
        return null;
    }

    @Override
    public final int getVersion() {
        return 35;
    }

    @Override
    public final SessionContextDTO tryAuthenticate(String user, String password) {
        return null;
    }

    @Override
    public SessionContextDTO tryAuthenticateAnonymously() {
        return null;
    }

    @Override
    public SessionContextDTO tryGetSession(String sessionToken) {
        this.logAccess(sessionToken, "tryGetSession", "SESSION(%s)", sessionToken);
        return null;
    }

    @Override
    public void checkSession(String sessionToken) throws InvalidSessionException {
        this.logAccess(sessionToken, "checkSession", "SESSION(%s)", sessionToken);
    }

    @Override
    public final void logout(String sessionToken) throws UserFailureException {
    }

    @Override
    public void expireSession(String sessionToken) throws UserFailureException {
    }

    @Override
    public void deactivatePersons(String sessionToken, List<String> personsCodes) {
        this.logTracking(sessionToken, "deactivatePersons", "PERSONS(%s)", this.abbreviate(personsCodes));
    }

    @Override
    public int countActivePersons(String sessionToken) {
        return 0;
    }

    @Override
    public boolean isArchivingConfigured(String sessionToken) {
        return false;
    }

    @Override
    public void saveDisplaySettings(String sessionToken, DisplaySettings displaySettings, int maxEntityVisits) {
        this.logTracking(sessionToken, "save_display_settings", RESULT_SUCCESS, new Object[0]);
    }

    @Override
    public void updateDisplaySettings(String sessionToken, IDisplaySettingsUpdate displaySettingsUpdate) {
        this.logTracking(sessionToken, "update_display_settings", "UPDATE (%s)", displaySettingsUpdate);
    }

    @Override
    public DisplaySettings getDefaultDisplaySettings(String sessionToken) {
        this.logTracking(sessionToken, "get_default_display_settings", RESULT_SUCCESS, new Object[0]);
        return null;
    }

    @Override
    public void changeUserHomeSpace(String sessionToken, TechId spaceIdOrNull) {
        String spaceId = spaceIdOrNull == null ? "null" : spaceIdOrNull.toString();
        this.logTracking(sessionToken, "change_user_home_space", "SPACE_ID (%s)", spaceId);
    }

    @Override
    public List<GridCustomColumn> listGridCustomColumns(String sessionToken, String gridId) {
        this.logAccess(sessionToken, "listGridCustomColumns", "GRID_ID(%s)", gridId);
        return null;
    }

    @Override
    public void setBaseIndexURL(String sessionToken, String baseURL) {
        this.logAccess(sessionToken, "set_base_url", "BASE_URL(%s)", baseURL);
    }

    @Override
    public String getBaseIndexURL(String sessionToken) {
        this.logAccess(sessionToken, "get_base_url", RESULT_SUCCESS, new Object[0]);
        return null;
    }

    @Override
    public void setSessionUser(String sessionToken, String userID) {
        this.logMessage(this.authLog, Level.INFO, sessionToken, "set_session_user", "USER(%s)", new Object[]{userID});
    }

    public int unarchiveDatasets(String sessionToken, List<String> datasetCodes) {
        this.logTracking(sessionToken, "unarchiveDatasets", "DATASETS(%s)", this.abbreviate(datasetCodes));
        return 0;
    }

    public int archiveDatasets(String sessionToken, List<String> datasetCodes, boolean removeFromDataStore) {
        this.logTracking(sessionToken, "archiveDatasets", "DATASETS(%s), REMOVE_FROM_DATA_STORE(%s)", this.abbreviate(datasetCodes), removeFromDataStore);
        return 0;
    }
}

