/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.generic.server;

import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewSample;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Sample;

public class NormalizedSampleIdentifier {
    private String containerSpace = "";
    private String containerCode = "";
    private String space;
    private String code;

    public NormalizedSampleIdentifier(Sample sample) {
        if (sample.getContainer() != null) {
            this.containerSpace = sample.getContainer().getSpace().getCode();
            this.containerCode = sample.getContainer().getCode();
        }
        this.space = sample.getSpace().getCode();
        this.code = sample.getCode().contains(":") ? sample.getCode().split(":")[1] : sample.getCode();
    }

    public NormalizedSampleIdentifier(NewSample sample, String homeSpace) {
        String[] split;
        String identifier = sample.getIdentifier();
        if (identifier.startsWith("/")) {
            split = identifier.split("/");
            this.space = split[1];
            this.code = split[2];
        } else {
            this.code = identifier;
        }
        if (this.space == null) {
            this.space = this.normalizeSpaceCode(sample.getDefaultSpaceIdentifier());
        }
        if (this.space == null) {
            this.space = this.normalizeSpaceCode(homeSpace);
        }
        if (this.space == null) {
            throw UserFailureException.fromTemplate("Cannot determine space for sample " + sample, new Object[0]);
        }
        if (this.code.contains(":")) {
            split = this.code.split(":");
            this.containerCode = split[0];
            this.code = split[1];
            this.containerSpace = this.space;
            if (!identifier.contains("/")) {
                throw new UserFailureException("Invalid sample identifier: " + identifier);
            }
        }
        if (sample.getCurrentContainerIdentifier() != null && !this.containerSpace.isEmpty()) {
            throw new UserFailureException("Container specified twice: " + sample.getIdentifier() + " and " + sample.getContainerIdentifier());
        }
        if (sample.getCurrentContainerIdentifier() != null) {
            String containerIdentifier = sample.getCurrentContainerIdentifier();
            if (containerIdentifier.contains("/")) {
                String[] split2 = sample.getCurrentContainerIdentifier().split("/");
                this.containerSpace = split2[1];
                this.containerCode = split2[2];
            } else {
                this.containerSpace = this.space;
                this.containerCode = containerIdentifier;
            }
        }
    }

    public String getSampleIdentifier() {
        return "/" + this.space + "/" + this.code;
    }

    public String getContainerIdentifier() {
        if (this.containerSpace.isEmpty()) {
            return null;
        }
        return "/" + this.containerSpace + "/" + this.containerCode;
    }

    public String getCode() {
        return this.code;
    }

    private String normalizeSpaceCode(String spaceCode) {
        if (spaceCode != null && spaceCode.startsWith("/")) {
            return spaceCode.substring(1);
        }
        return spaceCode;
    }

    public int hashCode() {
        return this.containerSpace.toUpperCase().hashCode() + this.containerCode.toUpperCase().hashCode() + this.space.toUpperCase().hashCode() + this.code.toUpperCase().hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof NormalizedSampleIdentifier)) {
            return false;
        }
        NormalizedSampleIdentifier nsi = (NormalizedSampleIdentifier)o;
        return nsi.containerSpace.equalsIgnoreCase(this.containerSpace) && nsi.containerCode.equalsIgnoreCase(this.containerCode) && nsi.space.equalsIgnoreCase(this.space) && nsi.code.equalsIgnoreCase(this.code);
    }
}

