/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.etl;

import ch.systemsx.cisd.openbis.dss.etl.AbstractImageDatasetUploader;
import ch.systemsx.cisd.openbis.dss.etl.AcquiredSingleImage;
import ch.systemsx.cisd.openbis.dss.etl.ImagingDatabaseHelper;
import ch.systemsx.cisd.openbis.dss.etl.MicroscopyImageDatasetInfo;
import ch.systemsx.cisd.openbis.dss.etl.dataaccess.IImagingQueryDAO;
import ch.systemsx.cisd.openbis.dss.etl.dto.ImageZoomLevel;
import ch.systemsx.cisd.openbis.dss.etl.dto.api.Channel;
import ch.systemsx.cisd.openbis.plugin.screening.shared.imaging.dataaccess.ImgImageZoomLevelDTO;
import java.util.List;
import java.util.Map;

public class MicroscopyImageDatasetUploader
extends AbstractImageDatasetUploader {
    public static void upload(IImagingQueryDAO dao, MicroscopyImageDatasetInfo dataset, List<AcquiredSingleImage> images, List<Channel> channels) {
        new MicroscopyImageDatasetUploader(dao).upload(dataset, images, channels);
    }

    private MicroscopyImageDatasetUploader(IImagingQueryDAO dao) {
        super(dao);
    }

    private void upload(MicroscopyImageDatasetInfo dataset, List<AcquiredSingleImage> images, List<Channel> channels) {
        long datasetId = this.getOrCreateMicroscopyDataset(dataset);
        ImagingDatabaseHelper.ImagingChannelsMap channelsMap = ImagingDatabaseHelper.getOrCreateDatasetChannels(this.dao, datasetId, channels);
        for (ImageZoomLevel imageZoomLevel : dataset.getImageDatasetInfo().getImageZoomLevels()) {
            long zoomLevelId = this.dao.addImageZoomLevel(this.convert(datasetId, imageZoomLevel));
            for (Map.Entry<String, String> entry : imageZoomLevel.getTransformation().entrySet()) {
                this.dao.addImageZoomLevelTransformation(zoomLevelId, channelsMap.getChannelId(entry.getKey()), entry.getValue());
            }
        }
        this.createImages(images, MicroscopyImageDatasetUploader.createDummySpotProvider(), channelsMap, datasetId);
    }

    private ImgImageZoomLevelDTO convert(long imageContainerDatasetId, ImageZoomLevel imageZoomLevel) {
        return new ImgImageZoomLevelDTO(imageZoomLevel.getPhysicalDatasetPermId(), imageZoomLevel.isOriginal(), imageZoomLevel.getRootPath(), imageZoomLevel.getWidth(), imageZoomLevel.getHeight(), imageZoomLevel.getColorDepth(), imageZoomLevel.getFileType(), imageContainerDatasetId);
    }

    private static AbstractImageDatasetUploader.ISpotProvider createDummySpotProvider() {
        return new AbstractImageDatasetUploader.ISpotProvider(){

            @Override
            public Long tryGetSpotId(AcquiredSingleImage image) {
                return null;
            }
        };
    }

    private long getOrCreateMicroscopyDataset(MicroscopyImageDatasetInfo dataset) {
        return this.getOrCreateImageDataset(dataset.getDatasetPermId(), dataset.getImageDatasetInfo(), null);
    }
}

