/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.screening.server.plugins;

import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.common.exceptions.ConfigurationFailureException;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.properties.PropertyUtils;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.tasks.IProcessingPluginTask;
import ch.systemsx.cisd.openbis.dss.generic.shared.DataSetProcessingContext;
import ch.systemsx.cisd.openbis.dss.generic.shared.ProcessingStatus;
import ch.systemsx.cisd.openbis.generic.shared.dto.DatasetDescription;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Properties;
import org.apache.log4j.Logger;

public class MarkerFileCreatingProcessingPlugin
implements IProcessingPluginTask {
    private static final String OUTPUT_DIR = "output-dir";
    private static final long serialVersionUID = 1L;
    private static final Logger operationLog = LogFactory.getLogger((LogCategory)LogCategory.OPERATION, MarkerFileCreatingProcessingPlugin.class);
    private final File outputDirectory;

    public MarkerFileCreatingProcessingPlugin(Properties properties, File storeRoot) {
        String directoryPath = PropertyUtils.getMandatoryProperty((Properties)properties, (String)OUTPUT_DIR);
        this.outputDirectory = new File(directoryPath);
        if (!this.outputDirectory.exists() || !this.outputDirectory.isDirectory()) {
            throw new ConfigurationFailureException("'output-dir' (" + directoryPath + ") should point to an existing directory.");
        }
    }

    public ProcessingStatus process(List<DatasetDescription> datasets, DataSetProcessingContext context) {
        for (DatasetDescription dataset : datasets) {
            File markerFile = new File(this.outputDirectory, dataset.getDataSetCode());
            try {
                markerFile.createNewFile();
            }
            catch (IOException ex) {
                CheckedExceptionTunnel.unwrapIfNecessary((Exception)ex);
            }
        }
        operationLog.info((Object)"Processing done.");
        return null;
    }
}

