/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.imagereaders.bioformats;

import ch.systemsx.cisd.common.geometry.SpatialPoint;
import ch.systemsx.cisd.common.shared.basic.string.StringUtils;
import ch.systemsx.cisd.imagereaders.ImageReaderTestCase;
import ch.systemsx.cisd.imagereaders.bioformats.FlexHelper;
import java.io.File;
import java.util.Map;
import org.testng.annotations.Test;

public class FlexHelperTest
extends ImageReaderTestCase {
    @Test
    public void testSimpleFile() throws Exception {
        File imageFile = this.getFlexFile("032045000.flex");
        FlexHelper helper = new FlexHelper(imageFile.getAbsolutePath());
        FlexHelperTest.assertEquals((int)1, (int)helper.getTileNumber(0));
        FlexHelperTest.assertEquals((String)"Exp1Cam1", (String)helper.getChannelCode(0));
        FlexHelperTest.assertEquals((String)"488", (String)helper.getExcitationTag(0));
        FlexHelperTest.assertEquals((String)"565/40", (String)helper.getEmissionTag(0));
        Map<Integer, SpatialPoint> tileCoordinates = helper.getTileCoordinates();
        FlexHelperTest.assertEquals((int)1, (int)tileCoordinates.size());
        FlexHelperTest.assertEquals((Object)new SpatialPoint(0.0, 0.0), (Object)tileCoordinates.get(1));
        String xml = helper.getMetadata();
        FlexHelperTest.assertFalse((boolean)StringUtils.isBlank((String)xml));
    }

    @Test
    public void testComplexFile() throws Exception {
        File imageFile = this.getFlexFile("001001000.flex");
        FlexHelper helper = new FlexHelper(imageFile.getAbsolutePath());
        String[] EXPOSURES = new String[]{"Exp1", "Exp1", "Exp2"};
        String[] CAMS = new String[]{"Cam1", "Cam3", "Cam2"};
        String[] EXCITATION = new String[]{"561,405", "561,405", "488"};
        String[] EMISSION = new String[]{"450/50", "690/70", "565/40"};
        int i = 0;
        while (i < 12) {
            int parsedTile = helper.getTileNumber(i);
            FlexHelperTest.assertEquals((int)(i / 3 + 1), (int)parsedTile);
            String channelName = String.valueOf(EXPOSURES[i % 3]) + CAMS[i % 3];
            FlexHelperTest.assertEquals((String)channelName, (String)helper.getChannelCode(i));
            FlexHelperTest.assertEquals((String)EXCITATION[i % 3], (String)helper.getExcitationTag(i));
            FlexHelperTest.assertEquals((String)EMISSION[i % 3], (String)helper.getEmissionTag(i));
            ++i;
        }
        Map<Integer, SpatialPoint> tileCoordinates = helper.getTileCoordinates();
        FlexHelperTest.assertEquals((int)4, (int)tileCoordinates.size());
        FlexHelperTest.assertEquals((Object)new SpatialPoint(4.44E-4, 6.61E-4), (Object)tileCoordinates.get(1));
        FlexHelperTest.assertEquals((Object)new SpatialPoint(-4.44E-4, 6.61E-4), (Object)tileCoordinates.get(2));
        FlexHelperTest.assertEquals((Object)new SpatialPoint(-4.44E-4, -6.61E-4), (Object)tileCoordinates.get(3));
        FlexHelperTest.assertEquals((Object)new SpatialPoint(4.44E-4, -6.61E-4), (Object)tileCoordinates.get(4));
        String xml = helper.getMetadata();
        FlexHelperTest.assertFalse((boolean)StringUtils.isBlank((String)xml));
    }

    private File getFlexFile(String fileName) {
        File flexImagesDir = new File("./sourceTest/resources/images/", "flex-helper");
        return new File(flexImagesDir, fileName);
    }
}

