/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ncml;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.Date;
import java.util.List;
import org.jdom.Element;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.dataset.DatasetConstructor;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.VariableDS;
import ucar.nc2.ncml.Aggregation;
import ucar.nc2.ncml.AggregationIF;
import ucar.nc2.ncml.NcMLReader;
import ucar.nc2.util.CancelTask;
import ucar.nc2.util.xml.Parse;

public class AggregationExisting
extends Aggregation {
    public AggregationExisting(NetcdfDataset ncd, String dimName, String recheckS) {
        super(ncd, dimName, AggregationIF.Type.JOIN_EXISTING, recheckS);
    }

    protected AggregationExisting(NetcdfDataset ncd, String dimName, AggregationIF.Type type, String recheckS) {
        super(ncd, dimName, type, recheckS);
    }

    protected void buildDataset(boolean isNew, CancelTask cancelTask) throws IOException {
        this.buildCoords(cancelTask);
        Aggregation.Dataset typicalDataset = this.getTypicalDataset();
        NetcdfFile typical = typicalDataset.acquireFile(null);
        DatasetConstructor.transferDataset(typical, this.ncDataset, isNew ? null : new Aggregation.MyReplaceVariableCheck(this));
        String dimName = this.getDimensionName();
        Dimension aggDim = new Dimension(dimName, this.getTotalCoords());
        this.ncDataset.removeDimension(null, dimName);
        this.ncDataset.addDimension(null, aggDim);
        for (Variable v : typical.getVariables()) {
            Dimension d;
            if (v.getRank() < 1 || !dimName.equals((d = v.getDimension(0)).getName())) continue;
            VariableDS vagg = new VariableDS(this.ncDataset, null, null, v.getShortName(), v.getDataType(), v.getDimensionsString(), null, null);
            vagg.setProxyReader(this);
            DatasetConstructor.transferVariableAttributes(v, vagg);
            this.ncDataset.removeVariable(null, v.getShortName());
            this.ncDataset.addVariable(null, vagg);
            if (cancelTask == null || !cancelTask.isCancel()) continue;
            return;
        }
        this.ncDataset.finish();
        this.makeProxies(typicalDataset, this.ncDataset);
        typical.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void persist() throws IOException {
        if (diskCache2 == null) {
            return;
        }
        AbstractInterruptibleChannel channel = null;
        try {
            FileLock lock;
            String cacheName = this.getCacheName();
            if (cacheName == null) {
                return;
            }
            File cacheFile = diskCache2.getCacheFile(cacheName);
            boolean exists = cacheFile.exists();
            if (!exists) {
                File dir = cacheFile.getParentFile();
                dir.mkdirs();
            }
            if (!this.wasChanged) {
                return;
            }
            FileOutputStream fos = new FileOutputStream(cacheFile);
            channel = fos.getChannel();
            try {
                lock = ((FileChannel)channel).tryLock();
            }
            catch (OverlappingFileLockException e) {
                if (channel != null) {
                    channel.close();
                }
                return;
            }
            if (lock == null) {
                return;
            }
            PrintStream out = new PrintStream(fos);
            out.print("<?xml version='1.0' encoding='UTF-8'?>\n");
            out.print("<aggregation xmlns='http://www.unidata.ucar.edu/namespaces/netcdf/ncml-2.2' ");
            out.print("type='" + this.type + "' ");
            if (this.dimName != null) {
                out.print("dimName='" + this.dimName + "' ");
            }
            if (this.recheck != null) {
                out.print("recheckEvery='" + this.recheck + "' ");
            }
            out.print(">\n");
            for (Aggregation.Dataset dataset : this.nestedDatasets) {
                out.print("  <netcdf location='" + dataset.getLocation() + "' ");
                out.print("ncoords='" + dataset.getNcoords(null) + "' ");
                if (dataset.coordValue != null) {
                    out.print("coordValue='" + dataset.coordValue + "' ");
                }
                out.print("/>\n");
            }
            out.print("</aggregation>\n");
            out.close();
            cacheFile.setLastModified(this.lastChecked);
            this.wasChanged = false;
            if (this.debug) {
                System.out.println("Aggregation persisted = " + cacheFile.getPath() + " lastModified= " + new Date(this.lastChecked));
            }
        }
        finally {
            if (channel != null) {
                channel.close();
            }
        }
    }

    protected void persistRead() {
        Element aggElem;
        String cacheName = this.getCacheName();
        if (cacheName == null) {
            return;
        }
        File cacheFile = diskCache2.getCacheFile(cacheName);
        if (!cacheFile.exists()) {
            return;
        }
        if (this.debug) {
            System.out.println(" *Read cache " + cacheFile.getPath());
        }
        try {
            aggElem = Parse.readRootElement(cacheFile.getPath());
        }
        catch (IOException e) {
            return;
        }
        List ncList = aggElem.getChildren("netcdf", NcMLReader.ncNS);
        for (int j = 0; j < ncList.size(); ++j) {
            Element netcdfElemNested = (Element)ncList.get(j);
            String location = netcdfElemNested.getAttributeValue("location");
            Aggregation.Dataset ds = this.findDataset(location);
            if (null == ds || ds.ncoord != 0) continue;
            if (this.debugCacheDetail) {
                System.out.println("  use cache for " + location);
            }
            String ncoordsS = netcdfElemNested.getAttributeValue("ncoords");
            try {
                ds.ncoord = Integer.parseInt(ncoordsS);
            }
            catch (NumberFormatException e) {
                logger.error("bad ncoord attribute on dataset=" + location);
            }
            String coordValue = netcdfElemNested.getAttributeValue("coordValue");
            if (coordValue == null) continue;
            ds.coordValue = coordValue;
        }
    }

    private Aggregation.Dataset findDataset(String location) {
        for (Aggregation.Dataset ds : this.nestedDatasets) {
            if (!location.equals(ds.getLocation())) continue;
            return ds;
        }
        return null;
    }

    private String getCacheName() {
        String cacheName = this.ncDataset.getLocation();
        if (cacheName == null) {
            cacheName = this.ncDataset.getCacheName();
        }
        return cacheName;
    }
}

