/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.bidimap;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.commons.collections.BidiMap;
import org.apache.commons.collections.OrderedBidiMap;
import org.apache.commons.collections.OrderedMap;
import org.apache.commons.collections.OrderedMapIterator;
import org.apache.commons.collections.ResettableIterator;
import org.apache.commons.collections.SortedBidiMap;
import org.apache.commons.collections.bidimap.AbstractDualBidiMap;
import org.apache.commons.collections.map.AbstractSortedMapDecorator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DualTreeBidiMap<K, V>
extends AbstractDualBidiMap<K, V>
implements SortedBidiMap<K, V>,
Serializable {
    private static final long serialVersionUID = 721969328361809L;
    protected final Comparator<? super K> comparator;

    public DualTreeBidiMap() {
        super(new TreeMap(), new TreeMap());
        this.comparator = null;
    }

    public static <E> DualTreeBidiMap<E, E> createTwoWayBidiMap(Comparator<? super E> comparator) {
        return new DualTreeBidiMap<E, E>(comparator, comparator);
    }

    public DualTreeBidiMap(Map<? extends K, ? extends V> map) {
        super(new TreeMap(), new TreeMap());
        this.putAll(map);
        this.comparator = null;
    }

    public DualTreeBidiMap(Comparator<? super K> comparator, Comparator<? super V> inverseComparator) {
        super(new TreeMap(comparator), new TreeMap(inverseComparator));
        this.comparator = comparator;
    }

    protected DualTreeBidiMap(Map<K, V> normalMap, Map<V, K> reverseMap, BidiMap<V, K> inverseBidiMap) {
        super(normalMap, reverseMap, inverseBidiMap);
        this.comparator = ((SortedMap)normalMap).comparator();
    }

    @Override
    protected <K, V> BidiMap<K, V> createBidiMap(Map<K, V> normalMap, Map<V, K> reverseMap, BidiMap<V, K> inverseMap) {
        return new DualTreeBidiMap<K, V>(normalMap, reverseMap, inverseMap);
    }

    @Override
    public Comparator<? super K> comparator() {
        return ((SortedMap)this.forwardMap).comparator();
    }

    @Override
    public K firstKey() {
        return ((SortedMap)this.forwardMap).firstKey();
    }

    @Override
    public K lastKey() {
        return ((SortedMap)this.forwardMap).lastKey();
    }

    @Override
    public K nextKey(K key) {
        if (this.isEmpty()) {
            return null;
        }
        if (this.forwardMap instanceof OrderedMap) {
            return ((OrderedMap)this.forwardMap).nextKey(key);
        }
        SortedMap sm = (SortedMap)this.forwardMap;
        Iterator<K> it = sm.tailMap(key).keySet().iterator();
        it.next();
        if (it.hasNext()) {
            return it.next();
        }
        return null;
    }

    @Override
    public K previousKey(K key) {
        if (this.isEmpty()) {
            return null;
        }
        if (this.forwardMap instanceof OrderedMap) {
            return ((OrderedMap)this.forwardMap).previousKey(key);
        }
        SortedMap sm = (SortedMap)this.forwardMap;
        SortedMap hm = sm.headMap(key);
        if (hm.isEmpty()) {
            return null;
        }
        return hm.lastKey();
    }

    @Override
    public OrderedMapIterator<K, V> orderedMapIterator() {
        return new BidiOrderedMapIterator(this);
    }

    @Override
    public SortedBidiMap<V, K> inverseSortedBidiMap() {
        return (SortedBidiMap)this.inverseBidiMap();
    }

    @Override
    public OrderedBidiMap<V, K> inverseOrderedBidiMap() {
        return (OrderedBidiMap)this.inverseBidiMap();
    }

    @Override
    public SortedMap<K, V> headMap(K toKey) {
        SortedMap sub = ((SortedMap)this.forwardMap).headMap(toKey);
        return new ViewMap(this, sub);
    }

    @Override
    public SortedMap<K, V> tailMap(K fromKey) {
        SortedMap sub = ((SortedMap)this.forwardMap).tailMap(fromKey);
        return new ViewMap(this, sub);
    }

    @Override
    public SortedMap<K, V> subMap(K fromKey, K toKey) {
        SortedMap sub = ((SortedMap)this.forwardMap).subMap(fromKey, toKey);
        return new ViewMap(this, sub);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeObject(this.forwardMap);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.forwardMap = new TreeMap(this.comparator);
        this.inverseMap = new TreeMap();
        Map map = (Map)in.readObject();
        this.putAll(map);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class BidiOrderedMapIterator<K, V>
    implements OrderedMapIterator<K, V>,
    ResettableIterator<K> {
        protected final AbstractDualBidiMap<K, V> parent;
        protected ListIterator<Map.Entry<K, V>> iterator;
        private Map.Entry<K, V> last = null;

        protected BidiOrderedMapIterator(AbstractDualBidiMap<K, V> parent) {
            this.parent = parent;
            this.iterator = new ArrayList<Map.Entry<K, V>>(parent.entrySet()).listIterator();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public K next() {
            this.last = this.iterator.next();
            return this.last.getKey();
        }

        @Override
        public boolean hasPrevious() {
            return this.iterator.hasPrevious();
        }

        @Override
        public K previous() {
            this.last = this.iterator.previous();
            return this.last.getKey();
        }

        @Override
        public void remove() {
            this.iterator.remove();
            this.parent.remove(this.last.getKey());
            this.last = null;
        }

        @Override
        public K getKey() {
            if (this.last == null) {
                throw new IllegalStateException("Iterator getKey() can only be called after next() and before remove()");
            }
            return this.last.getKey();
        }

        @Override
        public V getValue() {
            if (this.last == null) {
                throw new IllegalStateException("Iterator getValue() can only be called after next() and before remove()");
            }
            return this.last.getValue();
        }

        @Override
        public V setValue(V value) {
            if (this.last == null) {
                throw new IllegalStateException("Iterator setValue() can only be called after next() and before remove()");
            }
            if (this.parent.inverseMap.containsKey(value) && this.parent.inverseMap.get(value) != this.last.getKey()) {
                throw new IllegalArgumentException("Cannot use setValue() when the object being set is already in the map");
            }
            return this.parent.put(this.last.getKey(), value);
        }

        @Override
        public void reset() {
            this.iterator = new ArrayList<Map.Entry<K, V>>(this.parent.entrySet()).listIterator();
            this.last = null;
        }

        public String toString() {
            if (this.last != null) {
                return "MapIterator[" + this.getKey() + "=" + this.getValue() + "]";
            }
            return "MapIterator[]";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class ViewMap<K, V>
    extends AbstractSortedMapDecorator<K, V> {
        final DualTreeBidiMap<K, V> bidi;

        protected ViewMap(DualTreeBidiMap<K, V> bidi, SortedMap<K, V> sm) {
            super((SortedMap)((Object)bidi.createBidiMap(sm, bidi.inverseMap, bidi.inverseBidiMap)));
            this.bidi = (DualTreeBidiMap)this.map;
        }

        @Override
        public boolean containsValue(Object value) {
            return this.bidi.forwardMap.containsValue(value);
        }

        @Override
        public void clear() {
            Iterator it = this.keySet().iterator();
            while (it.hasNext()) {
                it.next();
                it.remove();
            }
        }

        @Override
        public SortedMap<K, V> headMap(K toKey) {
            return new ViewMap<K, V>(this.bidi, super.headMap(toKey));
        }

        @Override
        public SortedMap<K, V> tailMap(K fromKey) {
            return new ViewMap<K, V>(this.bidi, super.tailMap(fromKey));
        }

        @Override
        public SortedMap<K, V> subMap(K fromKey, K toKey) {
            return new ViewMap<K, V>(this.bidi, super.subMap(fromKey, toKey));
        }
    }
}

