/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.sybit.imageviewer.processors;

import ch.systemsx.sybit.imageviewer.data.ImageViewerParameters;
import ch.systemsx.sybit.imageviewer.data.MinMaxInChannel;
import ch.systemsx.sybit.imageviewer.data.SettingsUtil;
import ch.systemsx.sybit.imageviewer.processors.ContrastBrightnessProcessor;
import ij.ImagePlus;
import ij.process.FloatProcessor;
import ij.process.ShortProcessor;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.io.File;
import java.util.Map;
import javax.swing.ImageIcon;

public class ImageUtil {
    public static ImageIcon getScaledImageIcon(BufferedImage sourceImage, int width, int height, ImageObserver observer) {
        BufferedImage resultImage = new BufferedImage(width, height, sourceImage.getType());
        Graphics2D graphics2D = resultImage.createGraphics();
        graphics2D.drawImage(sourceImage, 0, 0, width, height, observer);
        graphics2D.dispose();
        return new ImageIcon(resultImage);
    }

    public static void modifyContrastBrightness(ImagePlus image, ImageViewerParameters imageViewerParameters) {
        ContrastBrightnessProcessor contrastBrightnessProcessor = new ContrastBrightnessProcessor(image.getType(), false, imageViewerParameters);
        contrastBrightnessProcessor.setMinAndMax(image, imageViewerParameters.getMin(), imageViewerParameters.getMax(), 3);
        if (image.getType() == 4) {
            contrastBrightnessProcessor = new ContrastBrightnessProcessor(image.getType(), true, imageViewerParameters);
            Map<Integer, MinMaxInChannel> minMaxChannels = imageViewerParameters.getMinMaxInChannels();
            if (minMaxChannels != null) {
                for (Integer channel : imageViewerParameters.getMinMaxInChannels().keySet()) {
                    contrastBrightnessProcessor.setMinAndMax(image, minMaxChannels.get(channel).getMin(), minMaxChannels.get(channel).getMax(), channel);
                }
            }
        }
    }

    public static ImagePlus createImagePlus(File file) {
        ImagePlus imagePlus = new ImagePlus(file.getAbsolutePath());
        return imagePlus;
    }

    public static ImagePlus generateImageCopy(ImagePlus image) {
        ImagePlus imagePlus = new ImagePlus(image.getTitle() + "orig", ImageUtil.generateBufferedImageCopy(image.getBufferedImage()));
        return imagePlus;
    }

    public static BufferedImage generateBufferedImageCopy(BufferedImage image) {
        BufferedImage resultImage = new BufferedImage(image.getWidth(), image.getHeight(), image.getType());
        Graphics2D graphics2D = resultImage.createGraphics();
        graphics2D.drawImage(image, 0, 0, image.getWidth(), image.getHeight(), null);
        graphics2D.dispose();
        return resultImage;
    }

    public static ImagePlus createScaledImagePlus(String filePath) {
        ImagePlus originalImage = new ImagePlus(filePath);
        if (originalImage != null && originalImage.getWidth() > SettingsUtil.localSystemThumbnailMaxWidth && originalImage.getHeight() > SettingsUtil.localSystemThumbnailMaxHeight) {
            int thumbnailScaleRatio = originalImage.getWidth() / SettingsUtil.localSystemThumbnailMaxWidth;
            if (originalImage.getHeight() / SettingsUtil.localSystemThumbnailMaxHeight > thumbnailScaleRatio) {
                thumbnailScaleRatio = originalImage.getHeight() / SettingsUtil.localSystemThumbnailMaxHeight;
            }
            originalImage.setProcessor(originalImage.getProcessor().resize(originalImage.getWidth() / thumbnailScaleRatio, originalImage.getHeight() / thumbnailScaleRatio));
        }
        return originalImage;
    }

    public static int[] calculateImageMinAndMaxForShortProcessor(ImagePlus imagePlus) {
        int shortMin = 65535;
        int shortMax = 0;
        for (int i = 0; i < imagePlus.getWidth(); ++i) {
            for (int j = 0; j < imagePlus.getHeight(); ++j) {
                int value = ((ShortProcessor)imagePlus.getProcessor()).getPixel(i, j);
                if (value < shortMin) {
                    shortMin = value;
                }
                if (value <= shortMax) continue;
                shortMax = value;
            }
        }
        return new int[]{shortMin, shortMax};
    }

    public static float[] calculateImageMinAndMaxForFloatProcessor(ImagePlus imagePlus) {
        float floatMin = Float.MAX_VALUE;
        float floatMax = -3.4028235E38f;
        for (int i = 0; i < imagePlus.getWidth(); ++i) {
            for (int j = 0; j < imagePlus.getHeight(); ++j) {
                float value = ((FloatProcessor)imagePlus.getProcessor()).getPixelValue(i, j);
                if (Float.isInfinite(value)) continue;
                if (value < floatMin) {
                    floatMin = value;
                }
                if (!(value > floatMax)) continue;
                floatMax = value;
            }
        }
        return new float[]{floatMin, floatMax};
    }
}

