/*
 * Decompiled with CFR 0.152.
 */
package thredds.datatype;

import java.text.ParseException;
import java.util.Date;
import thredds.datatype.DateType;
import thredds.datatype.TimeDuration;

public class DateRange {
    private DateType start;
    private DateType end;
    private TimeDuration duration;
    private TimeDuration resolution;
    private boolean invalid;
    private boolean useStart;
    private boolean useEnd;
    private boolean useDuration;
    private boolean useResolution;
    private volatile int hashCode = 0;

    public DateRange() throws ParseException {
        this(null, new DateType(false, new Date()), new TimeDuration("1 day"), new TimeDuration("15 min"));
    }

    public DateRange(Date start, Date end) {
        this(new DateType(false, start), new DateType(false, end), null, null);
    }

    public DateRange(DateRange range, String units) throws Exception {
        this(new DateType(false, range.getStart().getDate()), new DateType(false, range.getEnd().getDate()), null, new TimeDuration(units));
    }

    public DateRange(DateType start, DateType end, TimeDuration duration, TimeDuration resolution) {
        this.start = start;
        this.end = end;
        this.duration = duration;
        this.resolution = resolution;
        this.useStart = start != null && !start.isBlank();
        this.useEnd = end != null && !end.isBlank();
        this.useDuration = duration != null;
        this.useResolution = resolution != null;
        this.invalid = true;
        if (this.useStart && this.useEnd) {
            this.invalid = false;
            this.recalcDuration();
        } else if (this.useStart && this.useDuration) {
            this.invalid = false;
            this.end = start.add(duration);
        } else if (this.useEnd && this.useDuration) {
            this.invalid = false;
            this.start = end.subtract(duration);
        }
        if (this.invalid) {
            throw new IllegalArgumentException("DateRange must have 2 of start, end, duration");
        }
        this.hashCode = 0;
    }

    private String chooseResolution(double time) {
        if (time < 180.0) {
            return "secs";
        }
        if ((time /= 60.0) < 180.0) {
            return "minutes";
        }
        if ((time /= 60.0) < 72.0) {
            return "hours";
        }
        if ((time /= 24.0) < 90.0) {
            return "days";
        }
        if ((time /= 30.0) < 36.0) {
            return "months";
        }
        return "years";
    }

    private void recalcDuration() {
        long min = this.getStart().getDate().getTime();
        long max = this.getEnd().getDate().getTime();
        double secs = 0.001 * (double)(max - min);
        if (secs < 0.0) {
            secs = 0.0;
        }
        if (this.duration == null) {
            try {
                this.duration = new TimeDuration(this.chooseResolution(secs));
            }
            catch (ParseException e) {
                // empty catch block
            }
        }
        if (this.resolution == null) {
            this.duration.setValueInSeconds(secs);
        } else {
            double resSecs = this.resolution.getValueInSeconds();
            double closest = Math.round(secs / resSecs);
            secs = closest * resSecs;
            this.duration.setValueInSeconds(secs);
        }
        this.hashCode = 0;
    }

    public boolean included(Date d) {
        if (this.invalid) {
            return false;
        }
        if (this.start.after(d)) {
            return false;
        }
        return !this.end.before(d);
    }

    public boolean intersect(Date start_want, Date end_want) {
        if (this.invalid) {
            return false;
        }
        if (this.start.after(end_want)) {
            return false;
        }
        return !this.end.before(start_want);
    }

    public DateType getStart() {
        return this.start;
    }

    public void setStart(DateType start) {
        this.start = start;
        this.useStart = true;
        if (start.isPresent()) {
            this.end = start.add(this.duration);
            this.useEnd = false;
        } else if (this.end.isPresent()) {
            this.recalcDuration();
            this.start = this.end.subtract(this.duration);
        } else {
            this.recalcDuration();
            this.end = start.add(this.duration);
        }
    }

    public DateType getEnd() {
        return this.end;
    }

    public void setEnd(DateType end) {
        this.end = end;
        this.useEnd = true;
        if (end.isPresent()) {
            this.start = end.subtract(this.duration);
            this.useStart = false;
        } else if (this.start.isPresent()) {
            this.recalcDuration();
            this.end = this.start.add(this.duration);
        } else {
            this.recalcDuration();
            this.start = end.subtract(this.duration);
        }
    }

    public void extend(DateRange dr) {
        if (dr.getStart().getDate().before(this.start.getDate())) {
            this.setStart(dr.getStart());
        }
        if (dr.getEnd().getDate().after(this.end.getDate())) {
            this.setEnd(dr.getEnd());
        }
    }

    public TimeDuration getDuration() {
        return this.duration;
    }

    public void setDuration(TimeDuration duration) {
        this.duration = duration;
        this.useDuration = true;
        if (this.end.isPresent()) {
            this.start = this.end.subtract(duration);
            this.useStart = false;
        } else {
            this.end = this.start.add(duration);
            this.useEnd = false;
        }
    }

    public TimeDuration getResolution() {
        return this.resolution;
    }

    public void setResolution(TimeDuration resolution) {
        this.resolution = resolution;
        this.useResolution = true;
    }

    public boolean useStart() {
        return this.useStart;
    }

    public boolean useEnd() {
        return this.useEnd;
    }

    public boolean useDuration() {
        return this.useDuration;
    }

    public boolean useResolution() {
        return this.useResolution;
    }

    public boolean isPoint() {
        return this.start.equals(this.end);
    }

    public String toString() {
        return "start= " + this.start + " end= " + this.end + " duration= " + this.duration + " resolution= " + this.resolution;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DateRange)) {
            return false;
        }
        return o.hashCode() == this.hashCode();
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int result = 17;
            if (this.useStart) {
                result = 37 * result + this.start.hashCode();
            }
            if (this.useEnd) {
                result = 37 * result + this.end.hashCode();
            }
            if (this.useDuration) {
                result = 37 * result + this.duration.hashCode();
            }
            if (this.useResolution) {
                result = 37 * result + this.resolution.hashCode();
            }
            this.hashCode = result;
        }
        return this.hashCode;
    }
}

